package org.kikaineko.mock.analysis.junit4;

import org.kikaineko.mock.analysis.TestAnalyst;
import org.kikaineko.mock.framework.Import;
import org.kikaineko.mock.framework.ImportForJUnit4;
import org.kikaineko.mock.framework.junit4.TestClassForJunit4;
import org.kikaineko.source.util.TokenArray;
import org.kikaineko.source.util.TokenKind;
import org.kikaineko.util.IntArray;

public class TestAnalystForJUnit4 extends TestAnalyst {
	IntArray ignoreTestMethodIndex;

	public TestAnalystForJUnit4(TokenArray inTa) {
		super(inTa);
		ignoreTestMethodIndex = new IntArray();
	}

	/**
	 * @return
	 */
	protected void setTestClass() throws Exception {

		String pack = getPackage();

		Import[] im = getImports();

		int index = ta.indexOfVal("class");
		String name = ta.getVal(index + 1);

		tc = new TestClassForJunit4(pack, name);
		tc.setImports(im);

		ta = ta.takeSubArray(ta.indexOfVal("{", index) + 1, getIndexOfClosed(
				ta, index, TokenKind.BlockOpen, TokenKind.BlockClose));
	}

	private String getPackage() {
		int index = ta.indexOfVal("package");
		if (index == -1) {
			// ftHgpbP[W
			return "";
		}
		int endindex = ta.indexOfVal(";", index);
		StringBuffer sb = new StringBuffer();
		for (int i = index + 1; i < endindex; i++) {
			sb.append(ta.getVal(i));
		}
		return sb.toString();
	}

	protected Import[] getImports() {
		int num = ta.howManyOfVal("import");
		Import[] im = new Import[num];
		for (int i = 0; i < im.length; i++) {
			int from = ta.indexOfVal("import");
			int end = ta.indexOfVal(";", from);
			im[i] = new ImportForJUnit4(ta.takeSubArray(from, end + 1));
		}
		return im;

	}
	protected int getIndexOfTestMethod() {
		int i=getIndexOfTestMethodOrIgnore();
		while(i==-2){
			i=getIndexOfTestMethodOrIgnore();
		}
		return i;
	}
	protected int getIndexOfTestMethodOrIgnore() {
		int start = getIndexOfTestMethodForJUnit4();
		if(start==-1)
			return -1;
		
		int flag=ta.indexOfVal("@", "Ignore", start - 2);
		if(flag!=-1 && flag <start){
			start=flag;
			int end = getIndexOfClosed(ta, start, TokenKind.BlockOpen, TokenKind.BlockClose);
			ta.takeSubArray(start, end);
			return -2;
		}else{
			flag=ta.indexOfVal("@", "Ignore", start +1);
			int f2=ta.indexOfVal("{", start +1);
			if(flag!=-1 && flag < f2){
				int end = getIndexOfClosed(ta, start, TokenKind.BlockOpen, TokenKind.BlockClose);
				ta.takeSubArray(start, end);
				return -2;
			}
		}
		
		return start;
	}

	private int getIndexOfTestMethodForJUnit4() {
		return ta.indexOfVal("@", "Test");
	}

	protected int getIndexOfSetUp() {
		return ta.indexOfVal("@", "Before");
	}

	protected int getIndexOfTearDown() {
		return ta.indexOfVal("@", "After");
	}
	
	private int getIndexOfBeforeClass(){
		return ta.indexOfVal("@", "BeforeClass");
	}
	private int getIndexOfAfterClass(){
		return ta.indexOfVal("@", "AfterClass");
	}
	private void setBeforeClass() {
		int start = getIndexOfBeforeClass();
		if (start != -1) {
			int end = getIndexOfClosed(ta, start, TokenKind.BlockOpen, TokenKind.BlockClose);
			((TestClassForJunit4)tc).setBeforeClass(ta.takeSubArray(start, end + 1));
		} else {
			// tearDownI[o[ChȂꍇ
			// ftHg̉ȂeXgP[XĂ
			((TestClassForJunit4)tc).setBeforeClass(new TokenArray("{}"));
		}
	}
	private void setAfterClass() {
		int start = getIndexOfAfterClass();
		if (start != -1) {
			int end = getIndexOfClosed(ta, start, TokenKind.BlockOpen, TokenKind.BlockClose);
			((TestClassForJunit4)tc).setAfterClass(ta.takeSubArray(start, end + 1));
		} else {
			// tearDownI[o[ChȂꍇ
			// ftHg̉ȂeXgP[XĂ
			((TestClassForJunit4)tc).setAfterClass(new TokenArray("{}"));
		}
	}
	protected void setUpForAnalyze(){
		setBeforeClass();
		setAfterClass();
	}
	protected void tearDownForAnalyze() throws Exception {
		for (int i = 0; i < ignoreTestMethodIndex.length(); i++) {
			tc.removeTestMethod(ignoreTestMethodIndex.get(i) - i);
		}
		checkbJ[@();
	}

	protected void checkbJ[@() throws Exception {

	}

}
