package org.kikaineko.mock.framework;

import java.util.Vector;

class TargetHistoryTerm {

	private int symbol;

	private String methodName;

	private String[] args;

	private static Vector pool = new Vector();
	
	private boolean isDestroy=false;

	private TargetHistoryTerm(String methodName, String[] args, int i) {
		this.symbol = i;
		this.methodName = methodName;
		this.args = args;
	}

	public static int getSymbol(String methodName, String[] args) {
		TargetHistoryTerm tht = null;
		for (int i = 0; i < pool.size(); i++) {
			tht = (TargetHistoryTerm) pool.get(i);
			if (tht.equalsWith(methodName, args)) {
				return tht.getSymbol();
			}
		}
		tht = new TargetHistoryTerm(methodName, args, pool.size());
		pool.add(tht);
		return tht.getSymbol();
	}
	
	protected boolean isDestroy(){
		return isDestroy;
	}
	protected void mustBesDestroy(){
		isDestroy=true;
	}

	public static int count() {
		return pool.size();
	}

	public boolean equals(Object other) {
		if (this.methodName.equals(((TargetHistoryTerm) other).methodName)) {
			return this.args.equals(((TargetHistoryTerm) other).args);
		}
		return false;
	}

	public boolean equalsWith(String otherMethodName, String[] otherArg) {
		if (this.methodName.equals(otherMethodName)) {
			if(otherArg.length==args.length){
				for(int i=0;i<otherArg.length;i++){
					if(!otherArg[i].equals(args[i])){
						return false;
					}
				}
			}else{
				return false;
			}
			return true;
		}
		return false;
	}

	public int getSymbol() {
		return symbol;
	}

	public static void initialize() {
		pool = new Vector();
	}

	public static TargetHistoryTerm getBySymbol(int symbol) {
		try {
			return (TargetHistoryTerm) pool.get(symbol);
		} catch (Exception e) {
		}
		return null;
	}
	public String getArg(){
		StringBuffer history = new StringBuffer();
		if (args != null) {
			if(args.length==0){
				return "";
			}
			history.append("(");
			for (int i = 0; i < args.length; i++) {
				history.append(args[i]);
				history.append(" ");
			}
			history.append(")");
		}
		return history.toString();
	}
	public String[] getArgs() {
		return args;
	}

	public void setArg(String[] arg) {
		this.args = arg;
	}

	public String getMethodName() {
		return methodName;
	}

	public void setMethodName(String methodName) {
		this.methodName = methodName;
	}
	
	/**
	 * implementerɋLqHistoryTermŝ߂Ɏgp
	 * @return
	 */
	public String toStringAsStringArray() {
		StringBuffer sb=new StringBuffer("{");
		sb.append("\""+methodName+"\"");
		for(int i=0;i<args.length;i++){
			sb.append(",\""+args[i]+"\"");
		}
		sb.append("}");
		return sb.toString();
	}
	public String[] toStringArray(){
		String[] temps=new String[args.length+1];
		temps[0]=methodName;
		for(int i=0;i<args.length;i++){
			temps[i+1]=args[i];
		}
		return temps;
	}

}
