/*
 * Created on 2005/02/19
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

package org.kikaineko.mock.framework;

import java.util.Vector;

import org.kikaineko.source.util.TokenArray;
import org.kikaineko.source.util.TokenKind;

/**
 * ͂ƂȂeXg\NXB
 * 
 * @author Masayuki Ioki
 */
public class TestClass {
	private String pack;

	private String name;

	private TokenArray fieldsPart;

	private TestMethod setUp;

	private TestMethod tearDown;

	private Vector testMethods;

	private Import[] imports;

	private Vector methodsInTestCase;
	
	private Vector fieldNamesInTestCase;

	public TestClass(String pack, String name) {
		this.name = name;
		this.pack = pack;
		testMethods = new Vector();
		methodsInTestCase = new Vector();
		fieldNamesInTestCase=new Vector();
	}
	
	public void addFieldName(String name){
		fieldNamesInTestCase.add(name);
	}
	public String getFieldNameInTestCase(int i){
		return (String)fieldNamesInTestCase.get(i);
	}
	public int howManyFieldsInTestCase(){
		return fieldNamesInTestCase.size();
	}

	public void setSetUp(TokenArray ta) {
		setUp = new TestMethod(ta);
	}

	public String getClassName() {
		return name;
	}

	public String packageName() {
		return pack;
	}

	/**
	 * @return
	 */
	public TestMethod getSetUp() {
		return setUp;
	}

	/**
	 * @param i
	 * @return
	 */
	public TestMethod getTestMethod(int i) {
		return (TestMethod) testMethods.get(i);
	}

	public void addTestMethod(TokenArray ta) {
		testMethods.add(new TestMethod(ta));
	}

	public void addTestMethod(TestMethod tm) {
		testMethods.add(tm);
	}

	public void removeTestMethod(int i) {
		testMethods.remove(i);
	}

	/**
	 * @return
	 */
	public int howManyTestMethods() {
		return testMethods.size();
	}

	public void setImports(Import[] im) {
		imports = im;
	}

	public Import getImport(int i) {
		return imports[i];
	}

	public Import[] getImports() {
		return imports;
	}

	/**
	 * @return
	 */
	public int howManyImports() {
		return imports.length;
	}

	public TestMethod getTearDown() {
		return tearDown;
	}

	public void setTearDown(TokenArray array) {
		tearDown = new TestMethod(array);
	}

	public TokenArray getFieldsPart() {
		return fieldsPart;
	}

	public void setFieldsPart(TokenArray fieldsPart) {
		this.fieldsPart = fieldsPart;
	}

	public int howManyMethodsInTestCase() {
		return methodsInTestCase.size();
	}

	public void addMethod(TokenArray array) {
		int index = 0;
		// ŏ̗\ꕔ𖳎
		// UAi܂Ŕ΂
		for (index = 0; index < array.length(); index++) {
			if (array.getKind(index) == TokenKind.OpenKakko) {
				break;
			}
		}

		String name = array.getVal(index - 1);
		String type=getType(array,index-2);
		index++;
		Object[] args=getArgs(array,index);
		String[] types=(String[])args[0];
		String[] names=(String[])args[1];
		index++;
		MethodInTestCase mitc=new MethodInTestCase(array.subArray(index),name,type,names,types);
		methodsInTestCase.add(mitc);
	}

	private Object[] getArgs(TokenArray array, int index) {
		Vector types=new Vector();
		Vector names=new Vector();
		StringBuffer sb=new StringBuffer();
		for(;index<array.length();index++){
			int k=array.getKind(index);
			if(k==TokenKind.CloseKakko){
				break;
			}else if(k==TokenKind.Word){
				if(array.getKind(index-1)==TokenKind.Word){
					types.add(sb.toString());
					names.add(array.getVal(index));
					sb=new StringBuffer();
				}else{
					sb.append(array.getVal(index));
				}
			}else if(k==TokenKind.Piriod){
				sb.append(array.getVal(index));
			}
		}
		String[] ts=new String[types.size()];
		for(int i=0;i<ts.length;i++){
			ts[i]=(String)types.get(i);
		}
		String[] ns=new String[names.size()];
		for(int i=0;i<ns.length;i++){
			ns[i]=(String)names.get(i);
		}
		return new Object[]{ts,ns};
	}

	private String getType(TokenArray array, int index) {
		StringBuffer sb = new StringBuffer();
		boolean flag = false;
		for (int i = index; i > 0; i--) {
			if (array.getKind(i) == TokenKind.Word) {
				if (flag) {
					return sb.toString();
				} else {
					flag = true;
					sb.insert(0,array.getVal(i));
				}
			}else if(array.getKind(i) == TokenKind.Piriod){
				flag = false;
				sb.insert(0,array.getVal(i));
			}
		}
		return sb.toString();
	}

	public MethodInTestCase getMethodInTestCase(int i) {
		return (MethodInTestCase)methodsInTestCase.get(i);
	}
	
	public boolean includeMethodInTestCase(String name){
		for(int i=0;i<methodsInTestCase.size();i++){
			if(((MethodInTestCase)methodsInTestCase.get(i)).getNameByToStringer().startsWith(name)){
				return true;
			}
		}
		return false;
	}
	public MethodInTestCase getMethodInTestCase(String name){
		for(int i=0;i<methodsInTestCase.size();i++){
			MethodInTestCase m=(MethodInTestCase)methodsInTestCase.get(i);
			if(m.getNameByToStringer().equals(name)){
				return m;
			}
		}
		return null;
	}
}
