package org.kikaineko.mock.util;

/**
 * refer LevenshteinDistance. <br>
 * see! <br>
 * http://www.merriampark.com/ld.htm
 * 
 * @author masayuki
 * 
 */
public class LevenshteinDistance {
	private static int min(int i, int j, int k) {
		return Math.min(i, Math.min(j, k));
	}

	private static int[][] initMatrix(int n, int m) {
		int[][] distanceMatrix = new int[n + 1][m + 1];

		// Step 2

		for (int i = 0; i <= n; i++) {
			distanceMatrix[i][0] = i;
		}
		for (int j = 0; j <= m; j++) {
			distanceMatrix[0][j] = j;
		}
		return distanceMatrix;
	}

	public static double normalizedLD(String src, String dest) {
		if (dest.length() == 0) {
			if (src.length() == 0) {
				return 0;
			} else {
				return 1;
			}
		}
		double c = calc(src, dest);
		if (src.length() > dest.length()) {
			return c / src.length();
		} else {
			return c / dest.length();
		}
	}

	public static int calc(String src, String dest) {

		int n = src.length();
		int m = dest.length();
		if (n == 0) {
			return m;
		} else if (m == 0) {
			return n;
		}
		int[][] distanceMatrix = initMatrix(n, m);

		char[] destCs = dest.toCharArray();
		for (int i = 1; i <= n; i++) {
			char c = src.charAt(i - 1);
			for (int j = 1; j <= m; j++) {
				if (c == destCs[j - 1]) {
					distanceMatrix[i][j] = min(distanceMatrix[i - 1][j],
							distanceMatrix[i][j - 1],
							distanceMatrix[i - 1][j - 1] - 1) + 1;
				} else {
					distanceMatrix[i][j] = min(distanceMatrix[i - 1][j],
							distanceMatrix[i][j - 1],
							distanceMatrix[i - 1][j - 1]) + 1;
				}

			}

		}

		return distanceMatrix[n][m];

	}
}
