package org.kikaineko.mock.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;

public class ShortConstructorSeeker {
	private static Constructor shortConst(Constructor[] cs) {
		Vector vec = getNonException(cs);
		for (int i = 0; i < vec.size(); i++) {
			Constructor c = getUsingPrimitive(vec);
			if (c != null) {
				return c;
			}
		}
		Constructor c = getUsingPrimitive(cs);
		if(c!=null){
			return c;
		}
		return cs[0];
	}
	private static Constructor getUsingPrimitive(Constructor[] cs) {
		for (int i = 0; i < cs.length; i++) {
			Constructor c = cs[i];
			Class[] classes = c.getParameterTypes();
			if (allPrimit(classes)) {
				return c;
			}
		}
		return null;
	}

	private static Constructor getUsingPrimitive(Vector vcs) {
		for (int i = 0; i < vcs.size(); i++) {
			Constructor c = (Constructor) vcs.get(i);
			Class[] classes = c.getParameterTypes();
			if (allPrimit(classes)) {
				return c;
			}
		}
		return null;
	}

	private static boolean allPrimit(Class[] classes) {
		for (int i = 0; i < classes.length; i++) {
			if (!(classes[i].isPrimitive() || classes[i] == String.class)) {
				return false;
			}
		}
		return true;
	}

	private static Vector getNonException(Constructor[] cs) {
		Vector vec = new Vector();
		for (int i = 0; i < cs.length; i++) {
			if (cs[i].getExceptionTypes().length == 0) {
				vec.add(cs[i]);
			}
		}
		return vec;
	}

	public static Constructor getConst(Class clazz) {
		if (clazz == null)
			return null;
		try {
			return clazz.getConstructor(null);
		} catch (Exception e) {
		}
		Constructor[] cs = clazz.getDeclaredConstructors();
		if (cs.length != 0) {
			Comparator co = new Comparator() {
				public int compare(Object o1, Object o2) {
					return o1.toString().length() - o2.toString().length();
				}
			};
			Arrays.sort(cs, co);

			AccessibleObject.setAccessible(cs, true);
			return shortConst(cs);
		}
		return null;
	}

}
