/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 *  Copyright (C) 2000 - 2004 Hiroyuki Komatsu <komatsu@taiyaki.org>
 *  Copyright (C) 2004 Takuro Ashie <ashie@homa.ne.jp>
 *  Copyright (C) 2007 AOYAMA Kazz <kazz@users.sourceforge.jp>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 *  Boston, MA  02111-1307  USA
 *
 *  $Id$
 */

#ifdef HAVE_CONFIG_H
#include <config.h> 
#endif /* HAVE_CONFIG_H */
#include <gtk/gtk.h>
#include <tomoe-gtk.h>
#include "intl.h"


static void
print_committed_string (TomoeChar *ch)
{
    GString *tmp;
    const char *str;

    if (!ch) return;

    str = tomoe_char_get_utf8 (ch);
    if (!str) return;

    tmp = g_string_new ("commit_string:\t");
    g_string_append (tmp, str);
    g_string_append (tmp, "\n");

    fprintf (stdout, "%s", tmp->str);
    fflush (stdout);

    g_string_free (tmp, TRUE);
}


static void
char_clicked_handwriting (TomoeHandwriting *page, gpointer user_data)
{
    TomoeChar *ch;

    ch = tomoe_handwriting_get_selected_tomoe_char (page);
    if (!ch) return;

    print_committed_string (ch);
}


static void
char_clicked_charmap (TomoeGucharmap *gucharmap, gpointer user_data)
{
    GString *tmp;
    const char *str;

    str = tomoe_gucharmap_get_selected_char (gucharmap);
    if (!str) return;

    tmp = g_string_new ("commit_string:\t");
    g_string_append (tmp, str);
    g_string_append (tmp, "\n");

    fprintf (stdout, "%s", tmp->str);
    fflush (stdout);

    g_string_free (tmp, TRUE);
}


static void
char_clicked_readingsearch (TomoeReadingSearch *page, gpointer user_data)
{
    TomoeChar *ch;

    ch = tomoe_reading_search_get_selected_tomoe_char (page);
    if (!ch) return;

    print_committed_string (ch);
}


/*
 *  main
 */
int
main (int argc, char *argv[])
{
    GtkWidget *window;
    TomoeWindow *tomoe;
    void *page;

    setlocale (LC_ALL, "");
    bindtextdomain (PACKAGE, LOCALEDIR);
    textdomain (PACKAGE);
    bind_textdomain_codeset (PACKAGE, "UTF-8");

    gtk_init (&argc, &argv);

    window = tomoe_window_new ();
    gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_CENTER);
    gtk_widget_show (window);
    g_signal_connect (GTK_OBJECT (window), "destroy",
                      G_CALLBACK (gtk_main_quit), NULL);

    /* add hooks */
    tomoe = TOMOE_WINDOW (window);
    page = TOMOE_HANDWRITING (tomoe_window_get_handwriting_page (tomoe));
    g_signal_connect (G_OBJECT (page), "selected",
                      G_CALLBACK (char_clicked_handwriting), (gpointer) tomoe);

    page = TOMOE_GUCHARMAP (tomoe_window_get_gucharmap_page (tomoe));
    g_signal_connect (G_OBJECT (page), "selected",
                      G_CALLBACK (char_clicked_charmap), (gpointer) tomoe);

    page = TOMOE_READING_SEARCH (tomoe_window_get_reading_search_page (tomoe));
    g_signal_connect (G_OBJECT (page), "selected",
                      G_CALLBACK (char_clicked_readingsearch), (gpointer) tomoe);

    /* run */
    gtk_main ();

    return 0;
}
