<?php

class Plugin_image extends Plugin
{
	static $type = array(
			'png' => 'image/png',
			'jpeg' => 'image/jpeg',
			'jpg' => 'image/jpeg',
			'gif' => 'image/gif',
			'swf' => 'application/x-shockwave-flash'
	);
	
	
	function do_inline($pagename, $param1, $param2)
	{
		mb_ereg('^(.*?)(?:\s*,\s*(.*?))?$', trim($param1), $m);
		$file = $m[1];
		$page = $m[2] == '' ? $pagename : $m[2];
		
		if(!Attach::getinstance($page)->isexist($file)){
			return '<span class="warning">ファイルがありません</span>';
		}
		if(!mb_ereg('\.(.+?)$', $file, $m) || !isset(Plugin_image::$type[$m[1]])){
			return '<span class="warning">.' . htmlspecialchars($m[1]) . 'には対応していません</span>';
		}
		
		$url = SCRIPTPATH . '?plugin=image&amp;page=' . rawurlencode($page) . '&amp;file=' . rawurlencode($file);
		if($m[1] == 'swf'){
			$smarty = new PluginSmarty('image');
			$smarty->assign('url', $url);
			return $smarty->fetch('swf.tpl.htm');
		}
		return '<img src="' . $url . '" />';
	}
	
	
	function do_url()
	{
		$get = KinoWiki::getinstance()->getGET();
		
		if(!isset($get['page']) || !isset($get['file'])){
			exit();
		}
		
		if(!mb_ereg('\.(.+?)$', $get['file'], $m) || !isset(Plugin_image::$type[$m[1]])){
			exit();
		}
		
		
		$file = AttachedFile::getinstance($get['file'], $get['page']);
		header('Content-Type: ' . Plugin_image::$type[$m[1]]);
		header('Content-Length: ' . $file->getsize());
		echo $file->getdata();
		exit();
	}
}

?>