/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.contents.graphics;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import kinugasa.contents.graphics.ImageUtil;

public final class SerializableImage
implements Serializable {
    private static final long serialVersionUID = 2546606715890158812L;
    private transient BufferedImage image;

    public SerializableImage(BufferedImage image) throws NullPointerException {
        if (image == null) {
            throw new NullPointerException("image is null");
        }
        this.image = image;
    }

    public int getWidth() {
        return this.image.getWidth();
    }

    public int getHeight() {
        return this.image.getHeight();
    }

    public BufferedImage get() {
        return this.image;
    }

    public void set(BufferedImage image) {
        this.image = image;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.image.getWidth());
        stream.writeObject(ImageUtil.getPixel(this.image));
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int width = stream.readInt();
        int[] pixel = (int[])stream.readObject();
        this.image = ImageUtil.newImage(width, pixel.length / width);
        ImageUtil.setPixel(this.image, pixel);
    }
}

