/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.contents.resource;

import java.io.File;
import java.io.IOException;
import kinugasa.contents.resource.ContentsIOException;
import kinugasa.contents.resource.Nameable;
import kinugasa.contents.resource.TempFileStorage;
import kinugasa.game.GameLog;

public final class TempFile
implements Nameable {
    private File file;

    protected TempFile() throws ContentsIOException {
        this(TempFileStorage.getInstance().getPrefix(), TempFileStorage.getInstance().getSuffix());
    }

    protected TempFile(String prefix, String suffix) throws ContentsIOException {
        try {
            this.file = File.createTempFile(prefix, suffix);
        }
        catch (IOException e) {
            throw new ContentsIOException(e);
        }
        GameLog.printInfoIfUsing("Temp\u30d5\u30a1\u30a4\u30eb " + this.file.getPath() + " \u304c\u4f5c\u6210\u3055\u308c\u307e\u3057\u305f");
    }

    public String getPath() {
        return this.file.getPath();
    }

    public File getFile() {
        return this.file;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public void delete() {
        this.file.delete();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }
}

