/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.contents.resource;

import kinugasa.contents.resource.ContentsIOException;
import kinugasa.contents.resource.Storage;
import kinugasa.contents.resource.TempFile;
import kinugasa.game.GameLog;

public class TempFileStorage
extends Storage<TempFile> {
    private static final TempFileStorage INSTANCE = new TempFileStorage();
    private String prefix = "ktf_";
    private String suffix = ".tmp";

    private TempFileStorage() {
    }

    public static TempFileStorage getInstance() {
        return INSTANCE;
    }

    public TempFile create() throws ContentsIOException {
        TempFile file = new TempFile();
        this.add(file);
        return file;
    }

    public TempFile create(String prefix, String suffix) throws ContentsIOException {
        TempFile file = new TempFile(prefix, suffix);
        this.add(file);
        return file;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void deleteAll() {
        for (TempFile file : this) {
            if (!file.exists()) continue;
            file.delete();
        }
        GameLog.printInfoIfUsing("TempFileStorage : \u3059\u3079\u3066\u306e\u4e00\u6642\u30d5\u30a1\u30a4\u30eb\u3092\u524a\u9664\u3057\u307e\u3057\u305f");
    }
}

