/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.contents.sound;

import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import kinugasa.contents.resource.ContentsIOException;
import kinugasa.contents.resource.NotYetLoadedException;
import kinugasa.contents.sound.LoopPoint;
import kinugasa.contents.sound.ReverbModel;
import kinugasa.contents.sound.Sound;
import kinugasa.contents.sound.SoundBuilder;
import kinugasa.contents.sound.SoundStreamException;
import kinugasa.game.GameLog;
import kinugasa.util.StopWatch;

public class CachedSound
implements Sound {
    private static final HashMap<SoundBuilder, CachedSound> CACHE = new HashMap(16);
    private SoundBuilder builder;
    private transient Clip clip;
    private LoopPoint lp;
    private HashMap<Control.Type, Float> ctrls = new HashMap(8);

    static CachedSound create(SoundBuilder b) {
        if (CACHE.containsKey(b) && !b.isNewFile()) {
            GameLog.printInfoIfUsing("CachedSound \u30ad\u30e3\u30c3\u30b7\u30e5\u304c\u8fd4\u3055\u308c\u307e\u3057\u305f name=[" + b.getName() + "]");
            return CACHE.get(b);
        }
        CachedSound sc = new CachedSound(b);
        CACHE.put(b, sc);
        GameLog.printInfoIfUsing("CachedSound \u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u304c\u65b0\u898f\u4f5c\u6210\u3055\u308c\u307e\u3057\u305f name=[" + b.getName() + "]");
        return sc;
    }

    private CachedSound(SoundBuilder builder) {
        this.builder = builder;
        if (Float.compare(builder.getMasterGain(), 1.0f) != 0) {
            this.setControl(FloatControl.Type.MASTER_GAIN, (float)Math.log10(builder.getMasterGain()) * 20.0f);
        }
        if (Float.compare(builder.getVolume(), 1.0f) != 0) {
            this.setControl(FloatControl.Type.VOLUME, builder.getVolume());
        }
        if (Float.compare(builder.getPan(), 0.0f) != 0) {
            this.setControl(FloatControl.Type.PAN, builder.getPan());
        }
        if (!builder.getReverbModel().equals(ReverbModel.NO_USE)) {
            this.setControl(FloatControl.Type.REVERB_RETURN, builder.getReverbModel().getRet());
            this.setControl(FloatControl.Type.REVERB_SEND, builder.getReverbModel().getSend());
            this.setControl(BooleanControl.Type.APPLY_REVERB, builder.getReverbModel().isUse() ? 1.0f : 0.0f);
        }
        if (builder.getLoopPoint() != null && !builder.getLoopPoint().equals(LoopPoint.NO_USE)) {
            this.setLoopPoints(builder.getLoopPoint());
        }
        if (Float.compare(builder.getSampleRate(), 0.0f) != 0) {
            this.setControl(FloatControl.Type.SAMPLE_RATE, builder.getSampleRate());
        }
    }

    private void setControl(Control.Type t, float val) {
        this.ctrls.put(t, Float.valueOf(val));
    }

    private void setLoopPoints(LoopPoint p) {
        this.lp = p;
    }

    @Override
    public void setVolume(float vol) {
        FloatControl control = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
        control.setValue((float)Math.log10(vol) * 20.0f);
    }

    @Override
    public void play() throws NotYetLoadedException {
        if (!this.isLoaded()) {
            throw new NotYetLoadedException("sound " + this + " is not yet loaded.");
        }
        if (this.lp != LoopPoint.NO_USE) {
            this.clip.loop(-1);
        } else {
            this.clip.start();
        }
    }

    @Override
    public void again() {
        this.stop();
        this.play();
    }

    @Override
    public long getFramePosition() {
        return this.clip == null ? -1L : this.clip.getLongFramePosition();
    }

    @Override
    public long getFrameLength() {
        return this.clip == null ? -1L : (long)this.clip.getFrameLength();
    }

    @Override
    public void stop() {
        if (this.clip != null) {
            this.clip.stop();
            this.clip.setFramePosition(0);
        }
    }

    @Override
    public void pause() {
        if (this.clip != null) {
            this.clip.stop();
        }
    }

    @Override
    public boolean isRunning() {
        return this.clip == null ? false : this.clip.isRunning();
    }

    @Override
    public CachedSound load() throws ContentsIOException, SoundStreamException {
        if (this.isLoaded()) {
            return this;
        }
        StopWatch watch = new StopWatch().start();
        AudioInputStream stream = null;
        try {
            stream = AudioSystem.getAudioInputStream(this.builder.getFile());
            DataLine.Info dInfo = new DataLine.Info(Clip.class, stream.getFormat());
            this.clip = (Clip)AudioSystem.getLine(dInfo);
            this.clip.open(stream);
            Set<Control.Type> types = this.ctrls.keySet();
            for (Control.Type t : types) {
                float val = this.ctrls.get(t).floatValue();
                try {
                    FloatControl control = (FloatControl)this.clip.getControl(t);
                    control.setValue(val);
                }
                catch (IllegalArgumentException i) {
                    GameLog.printInfoIfUsing("! > SoundClip : [" + this.getName() + "] : UN SUPPORTED CONTROL : Type=[" + t + "]");
                }
            }
            if (this.lp != null) {
                this.clip.setLoopPoints(this.lp.getTo(), this.lp.getFrom());
            }
        }
        catch (Exception ex) {
            throw new SoundStreamException(ex);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException ex) {
                throw new ContentsIOException(ex);
            }
        }
        watch.stop();
        GameLog.printInfoIfUsing("CachedSound \u30ed\u30fc\u30c9\u3057\u307e\u3057\u305f name=[" + this.getName() + "](" + watch.getTime() + " ms)");
        return this;
    }

    @Override
    public CachedSound free() {
        this.stop();
        if (this.clip != null) {
            this.clip.flush();
            this.clip.close();
        }
        this.clip = null;
        GameLog.printInfoIfUsing("CachedSound : [" + this.getName() + "] : FREE");
        return this;
    }

    @Override
    public boolean isLoaded() {
        return this.clip != null;
    }

    public String toString() {
        return "CachedSound{name=" + this.getName() + ", lp=" + this.lp + ", load=" + this.isLoaded() + ", run=" + this.isRunning() + '}';
    }

    @Override
    public String getName() {
        return this.builder.getName();
    }

    public SoundBuilder getBuilder() {
        return this.builder;
    }
}

