/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.contents.text;

import java.io.File;
import java.util.Collection;
import kinugasa.contents.resource.ContentsFileNotFoundException;
import kinugasa.contents.resource.IllegalFormatException;
import kinugasa.contents.resource.NameNotFoundException;
import kinugasa.contents.text.Property;
import kinugasa.contents.text.Reader;
import kinugasa.contents.text.TextIO;
import kinugasa.contents.text.TextReader;

public final class INIReader
extends TextReader<Property> {
    private static final Reader<Property> INI_READER = new Reader<Property>(){
        private static final long serialVersionUID = -7632402600321932711L;

        @Override
        public Property parse(String line) throws IllegalFormatException {
            if (!line.startsWith("#") && !"".equals(line) && line.indexOf(61) < 0) {
                throw new IllegalFormatException("! > INI_PARSER : ERROR : line=[" + line + "]");
            }
            if (line.startsWith("#") || "".equals(line)) {
                return null;
            }
            String[] values = line.split("=");
            if (values.length == 1) {
                values = new String[]{values[0], ""};
            }
            return new Property(values[0], values[1]);
        }
    };
    private static final long serialVersionUID = 8688808534234682761L;

    public INIReader(File file) throws ContentsFileNotFoundException {
        super(file, INI_READER);
    }

    public INIReader(String filePath) throws ContentsFileNotFoundException {
        super(filePath, INI_READER);
    }

    @Override
    public INIReader load() throws IllegalFormatException {
        return (INIReader)super.load();
    }

    @Override
    public INIReader free() {
        return (INIReader)super.free();
    }

    public Property get(String name) throws NameNotFoundException {
        for (Property prop : this) {
            if (!prop.getName().equals(name)) continue;
            return prop;
        }
        throw new NameNotFoundException("not found : name=[" + name + "]");
    }

    public Property getIfContains(String name) {
        for (Property prop : this) {
            if (!prop.getName().equals(name)) continue;
            return prop;
        }
        return null;
    }

    public boolean contains(String name) {
        return this.getIfContains(name) != null;
    }

    public INIReader add(Collection<? extends Property> obj) {
        return (INIReader)super.add(obj);
    }

    public INIReader add(Property obj) {
        return (INIReader)super.add(obj);
    }

    public INIReader add(Property ... obj) {
        return (INIReader)super.add(obj);
    }

    public INIReader add(TextIO<? extends Property> other) {
        return (INIReader)super.add(other);
    }

    public INIReader remove(Collection<? extends Property> obj) {
        return (INIReader)super.remove(obj);
    }

    public INIReader remove(Property obj) {
        return (INIReader)super.remove(obj);
    }

    public INIReader remove(Property ... obj) {
        return (INIReader)super.remove(obj);
    }

    public INIReader remove(TextIO<? extends Property> other) {
        return (INIReader)super.remove(other);
    }

    @Override
    public INIReader clear() {
        return (INIReader)super.clear();
    }
}

