/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.contents.text;

import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kinugasa.contents.resource.Nameable;

public abstract class TextIO<T>
implements Iterable<T>,
Nameable,
Serializable {
    private static final long serialVersionUID = -4706947051077791206L;
    protected final File file;
    protected final ArrayList<T> data;

    public TextIO(String filePath) {
        this(new File(filePath));
    }

    public TextIO(File file) {
        this.file = file;
        this.data = new ArrayList(32);
    }

    public final ArrayList<T> getData() {
        return this.data;
    }

    public final T getFirst() {
        return this.data.isEmpty() ? null : (T)this.data.get(0);
    }

    public final File getFile() {
        return this.file;
    }

    public TextIO<T> add(T obj) {
        this.data.add(obj);
        return this;
    }

    public TextIO<T> add(T ... obj) {
        this.data.addAll(Arrays.asList(obj));
        return this;
    }

    public TextIO<T> add(Collection<? extends T> obj) {
        this.data.addAll(this.data);
        return this;
    }

    public TextIO<T> add(TextIO<? extends T> other) {
        this.add((Collection<? extends T>)other.data);
        return this;
    }

    public TextIO<T> remove(T obj) {
        this.data.remove(obj);
        return this;
    }

    public TextIO<T> remove(T ... obj) {
        this.data.removeAll(Arrays.asList(obj));
        return this;
    }

    public TextIO<T> remove(Collection<? extends T> obj) {
        this.data.removeAll(this.data);
        return this;
    }

    public TextIO<T> remove(TextIO<? extends T> other) {
        this.remove((Collection<? extends T>)other.data);
        return this;
    }

    public TextIO<T> clear() {
        this.data.clear();
        return this;
    }

    public final int size() {
        return this.data.size();
    }

    public final boolean isEmpty() {
        return this.data.isEmpty();
    }

    public String toString() {
        return "TextIO{file=" + this.file + ", data=" + this.data + '}';
    }

    public void printAll(PrintStream stream) {
        stream.println("> TextIO : " + this);
        for (T obj : this) {
            stream.println(obj);
        }
        stream.println("> TextIO : ------------------------");
    }

    @Override
    public Iterator<T> iterator() {
        return this.data.iterator();
    }

    @Override
    public final String getName() {
        return this.file.getName();
    }
}

