/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.contents.text;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import kinugasa.contents.resource.ContentsIOException;
import kinugasa.contents.text.TextIO;
import kinugasa.contents.text.Writer;
import kinugasa.game.GameLog;

public class TextWriter<T>
extends TextIO<T> {
    private static final long serialVersionUID = 6062888702166716010L;
    private Writer<T> writer;

    public TextWriter(File file, Writer<T> writer) {
        super(file);
        this.writer = writer;
    }

    public TextWriter(String filePath, Writer<T> writer) {
        super(filePath);
        this.writer = writer;
    }

    public void save() throws ContentsIOException {
        FileWriter fw = null;
        BufferedWriter bw = null;
        try {
            fw = new FileWriter(this.file);
            bw = new BufferedWriter(fw);
            for (Object obj : this) {
                String line = this.writer.toString(obj);
                bw.write(line, 0, line.length());
                bw.newLine();
            }
            GameLog.printInfoIfUsing("TextWriter\uff08\u30bb\u30fc\u30d6\uff09[" + this.file.getName() + "] size=[" + this.size() + "]");
        }
        catch (IOException ex) {
            throw new ContentsIOException(ex);
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException ex) {
                throw new ContentsIOException(ex);
            }
        }
    }

    @Override
    public TextWriter<T> add(Collection<? extends T> obj) {
        return (TextWriter)super.add(obj);
    }

    @Override
    public TextWriter<T> add(T obj) {
        return (TextWriter)super.add(obj);
    }

    @Override
    public TextWriter<T> add(T ... obj) {
        return (TextWriter)super.add(obj);
    }

    @Override
    public TextWriter<T> add(TextIO<? extends T> other) {
        return (TextWriter)super.add(other);
    }

    @Override
    public TextWriter<T> remove(Collection<? extends T> obj) {
        return (TextWriter)super.remove(obj);
    }

    @Override
    public TextWriter<T> remove(T obj) {
        return (TextWriter)super.remove(obj);
    }

    @Override
    public TextWriter<T> remove(T ... obj) {
        return (TextWriter)super.remove(obj);
    }

    @Override
    public TextWriter<T> remove(TextIO<? extends T> other) {
        return (TextWriter)super.remove(other);
    }

    @Override
    public TextWriter<T> clear() {
        return (TextWriter)super.clear();
    }

    public Writer<T> getWriter() {
        return this.writer;
    }

    public void setWriter(Writer<T> writer) {
        this.writer = writer;
    }
}

