/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.contents.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import kinugasa.contents.text.XMLAttribute;
import kinugasa.contents.text.XMLAttributeStorage;
import kinugasa.contents.text.XMLElement;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XMLParserUtil {
    private XMLParserUtil() {
    }

    public static XMLElement createElement(Node node) {
        String nodeName = node.getNodeName();
        List<XMLAttribute> attributes = XMLParserUtil.getAttributes(node.getAttributes());
        NodeList nodeList = node.getChildNodes();
        HashMap<String, List<XMLElement>> childElements = new HashMap<String, List<XMLElement>>(nodeList.getLength());
        String textValue = node.getNodeValue();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node element = nodeList.item(i);
            if ("#text".equals(element.getNodeName())) {
                textValue = element.getNodeValue();
                continue;
            }
            if (!childElements.containsKey(element.getNodeName())) {
                childElements.put(element.getNodeName(), new ArrayList());
            }
            ((List)childElements.get(element.getNodeName())).add(XMLParserUtil.createElement(element));
        }
        return new XMLElement(nodeName, childElements, new XMLAttributeStorage(attributes), textValue);
    }

    public static List<XMLAttribute> getAttributes(NamedNodeMap nodeMap) {
        if (nodeMap == null) {
            return Collections.emptyList();
        }
        ArrayList<XMLAttribute> attributes = new ArrayList<XMLAttribute>(nodeMap.getLength());
        for (int i = 0; i < nodeMap.getLength(); ++i) {
            attributes.add(new XMLAttribute(nodeMap.item(i).getNodeName(), nodeMap.item(i).getNodeValue()));
        }
        return attributes;
    }
}

