/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.contents.text;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import kinugasa.contents.resource.ContentsFileNotFoundException;
import kinugasa.contents.resource.ContentsIOException;
import kinugasa.contents.resource.Freeable;
import kinugasa.contents.resource.IllegalXMLFormatException;
import kinugasa.contents.resource.Loadable;
import kinugasa.contents.text.TextIO;
import kinugasa.contents.text.XMLElement;
import kinugasa.contents.text.XMLParserUtil;
import kinugasa.game.GameLog;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class XMLReader
extends TextIO<XMLElement>
implements Freeable,
Loadable {
    private static final long serialVersionUID = -2592533787944999083L;

    public XMLReader(File file) throws ContentsFileNotFoundException {
        super(file);
        if (!file.exists()) {
            throw new ContentsFileNotFoundException("file not found : [" + file.getPath() + "]");
        }
    }

    public XMLReader(String filePath) throws ContentsFileNotFoundException {
        this(new File(filePath));
    }

    private static DocumentBuilderFactory openBuilderFactory() {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setValidating(true);
        builderFactory.setIgnoringComments(true);
        builderFactory.setIgnoringElementContentWhitespace(true);
        return builderFactory;
    }

    @Override
    public XMLReader load() throws IllegalXMLFormatException, ContentsFileNotFoundException, ContentsIOException {
        DocumentBuilderFactory builderFactory = XMLReader.openBuilderFactory();
        Document document = null;
        try {
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            builder.setErrorHandler(null);
            document = builder.parse(this.file);
        }
        catch (SAXException ex) {
            throw new IllegalXMLFormatException(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalXMLFormatException(ex);
        }
        catch (FileNotFoundException ex) {
            throw new ContentsFileNotFoundException(ex);
        }
        catch (IOException ex) {
            throw new ContentsIOException(ex);
        }
        assert (document != null) : "document is null";
        this.data.add(XMLParserUtil.createElement(document.getLastChild()));
        GameLog.printInfoIfUsing("XMLReader \u30ed\u30fc\u30c9\u3057\u307e\u3057\u305f[" + this.file.getName() + "]");
        return this;
    }

    @Override
    public XMLReader free() {
        this.data.clear();
        return this;
    }

    @Override
    public boolean isLoaded() {
        return !this.data.isEmpty();
    }

    public XMLReader add(Collection<? extends XMLElement> obj) {
        return (XMLReader)super.add(obj);
    }

    public XMLReader add(TextIO<? extends XMLElement> other) {
        return (XMLReader)super.add(other);
    }

    public XMLReader add(XMLElement obj) {
        return (XMLReader)super.add(obj);
    }

    public XMLReader add(XMLElement ... obj) {
        return (XMLReader)super.add((T[])obj);
    }

    public XMLReader clear() {
        return (XMLReader)super.clear();
    }

    public XMLReader remove(Collection<? extends XMLElement> obj) {
        return (XMLReader)super.remove(obj);
    }

    public XMLReader remove(TextIO<? extends XMLElement> other) {
        return (XMLReader)super.remove(other);
    }

    public XMLReader remove(XMLElement obj) {
        return (XMLReader)super.remove(obj);
    }

    public XMLReader remove(XMLElement ... obj) {
        return (XMLReader)super.remove((T[])obj);
    }
}

