/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.game;

import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import kinugasa.contents.graphics.ImageUtil;
import kinugasa.contents.resource.TempFileStorage;
import kinugasa.game.AWTGameWindow;
import kinugasa.game.AlreadyExecutedException;
import kinugasa.game.CMDArgs;
import kinugasa.game.Game;
import kinugasa.game.GameConfig;
import kinugasa.game.GameLog;
import kinugasa.game.GameLoop;
import kinugasa.game.GameTimeManager;
import kinugasa.game.GameWindow;
import kinugasa.game.LockUtil;
import kinugasa.game.PlayerConstants;
import kinugasa.game.WindowCloseEvent;
import kinugasa.inputDevice.KeyConnection;
import kinugasa.inputDevice.MouseConnection;
import kinugasa.util.Versions;

public abstract class KinugasaGame
extends Game {
    private AWTGameWindow window;
    private BufferStrategy graphicsBuffer;
    private Graphics2D graphicsContext;
    private RenderingHints renderingHints;
    private GameLoop loop;
    private GameTimeManager gameTimeManager;
    private Rectangle clippingRectangle;
    private boolean updateIfNotActive;
    private int fps;
    private boolean started = false;

    protected KinugasaGame(GameConfig conf) {
        super(conf.getTitle());
        if (conf.getLogPath() != null) {
            GameLog.usingLog(conf.getLogPath());
            try {
                FileHandler handler = new FileHandler(conf.getLogPath());
                handler.setLevel(Level.ALL);
                handler.setFormatter(new Formatter(){
                    final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

                    @Override
                    public String format(LogRecord record) {
                        StringBuilder line = new StringBuilder();
                        line.append(this.DATE_FORMAT.format(new Date(record.getMillis()))).append(' ');
                        line.append(record.getLevel().getName()).append(' ');
                        if (record.getThrown() != null) {
                            line.append("\uff08\u4f8b\u5916\uff09").append(record.getThrown().getMessage());
                        } else {
                            line.append(record.getMessage());
                        }
                        line.append(System.lineSeparator());
                        return line.toString();
                    }
                });
                Logger.getGlobal().addHandler(handler);
            }
            catch (IOException ex) {
                GameLog.print(Level.WARNING, ex);
            }
            catch (SecurityException ex) {
                GameLog.print(Level.WARNING, ex);
            }
            GameLog.printInfo("\u30ed\u30b0\u30d5\u30a1\u30a4\u30eb[" + conf.getLogPath() + "]\u3092\u4f7f\u7528\u3057\u307e\u3059");
        }
        if (conf.isLock()) {
            if (LockUtil.isExistsLockFile()) {
                throw new AlreadyExecutedException(LockUtil.listLockFile());
            }
            LockUtil.createLockFile();
        }
        this.window = new AWTGameWindow();
        this.renderingHints = conf.getRenderingHints();
        this.window.getCloseEventStorage().addAll(conf.getCloseEvetList());
        this.window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                List<WindowCloseEvent> eventList = KinugasaGame.this.window.getCloseEventStorage().asSortedList();
                int size = eventList.size();
                for (int i = 0; i < size; ++i) {
                    if (eventList.get(i).close()) continue;
                    return;
                }
                KinugasaGame.this.gameExit();
            }
        });
        this.window.setTitle(conf.getTitle());
        this.window.setIconImage(conf.getIcon());
        this.window.setBackground(conf.getBackColor());
        this.window.setLocation(conf.getLocation());
        this.window.setSize(conf.getSize());
        this.window.setResizable(false);
        PlayerConstants playerConstants = PlayerConstants.getInstance();
        playerConstants.setUsingKeyboard(conf.isUseKeyboard());
        if (playerConstants.isUsingKeyboard()) {
            KeyConnection.setListener(this.window);
        }
        playerConstants.setUsingMouse(conf.isUseMouseCursor());
        if (playerConstants.isUsingMouse()) {
            MouseConnection.setListener(this.window);
        } else {
            BufferedImage cursorImage = ImageUtil.newImage(16, 16);
            this.window.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(cursorImage, new Point(), "game cursor"));
        }
        this.fps = conf.getFps();
        this.updateIfNotActive = conf.isUpdateIfNotActive();
    }

    public KinugasaGame(String name) {
        this(new GameConfig(name));
    }

    @Override
    protected final void gameStart(String[] args) throws IllegalStateException {
        if (this.started) {
            throw new IllegalStateException("\u3053\u306e\u30b2\u30fc\u30e0\u306f\u3059\u3067\u306b\u958b\u59cb\u3057\u3066\u3044\u307e\u3059 [" + this.name + "]");
        }
        CMDArgs.getInstance().setArgs(args);
        this.gameTimeManager = new GameTimeManager(this.fps);
        this.loop = new GameLoop(this, this.gameTimeManager, this.updateIfNotActive);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    KinugasaGame.this.startUp();
                }
                catch (Throwable ex) {
                    GameLog.print(Level.WARNING, "ERROR : " + ex);
                    System.exit(1);
                }
                KinugasaGame.this.window.setVisible(true);
                KinugasaGame.this.window.createBufferStrategy(2);
                KinugasaGame.this.graphicsBuffer = KinugasaGame.this.window.getBufferStrategy();
                KinugasaGame.this.clippingRectangle = KinugasaGame.this.window.getInternalBounds();
                KinugasaGame.this.started = true;
                GameLog.printInfo("---- gameStart\u304c\u5b8c\u4e86\u3001loop\u3092\u958b\u59cb\u3057\u307e\u3059");
                KinugasaGame.this.loop.start();
            }
        });
        GameLog.printInfoIfUsing("KINUGASA-" + Versions.getLatest().getValue() + " [" + this.getName() + "]\u3092\u958b\u59cb\u3057\u307e\u3057\u305f");
    }

    @Override
    public final void gameExit() throws IllegalStateException {
        if (!this.started) {
            throw new IllegalStateException("[" + this.name + "]\u306f\u958b\u59cb\u3057\u3066\u3044\u307e\u305b\u3093");
        }
        if (this.loop != null && this.loop.isStarted()) {
            this.loop.end();
        }
        try {
            this.dispose();
        }
        catch (Throwable ex) {
            GameLog.print(Level.WARNING, "ERROR : " + ex);
            System.exit(1);
        }
        GameLog.printInfoIfUsing("----gameExit\u3092\u958b\u59cb\u3057\u307e\u3059");
        this.window.dispose();
        TempFileStorage.getInstance().deleteAll();
        LockUtil.deleteLockFile();
        GameLog.printInfoIfUsing("KINUGASA-" + Versions.getLatest().getValue() + " [" + this.getName() + "]\u3092\u7d42\u4e86\u3057\u307e\u3059");
        System.exit(0);
    }

    @Override
    final void repaint() {
        this.graphicsContext = (Graphics2D)this.graphicsBuffer.getDrawGraphics();
        this.graphicsContext.setClip(this.clippingRectangle);
        this.graphicsContext.clearRect(this.clippingRectangle.x, this.clippingRectangle.y, this.clippingRectangle.width, this.clippingRectangle.height);
        this.graphicsContext.setRenderingHints(this.renderingHints);
        this.draw(this.graphicsContext);
        this.graphicsContext.dispose();
        if (this.graphicsBuffer.contentsRestored()) {
            this.repaint();
        }
        this.graphicsBuffer.show();
        if (this.graphicsBuffer.contentsLost()) {
            this.repaint();
        }
    }

    @Override
    protected abstract void startUp();

    @Override
    protected abstract void dispose();

    @Override
    protected abstract void update();

    @Override
    protected abstract void draw(Graphics2D var1);

    @Override
    public final GameWindow getWindow() {
        return this.window;
    }

    @Override
    public final GameTimeManager getGameTimeManager() {
        return this.gameTimeManager;
    }

    @Override
    public String toString() {
        return "kinugasaGame : name=[" + this.name + "]";
    }

    public static void main(String[] args) {
        GameLog.printInfoIfUsing("KINUGASA " + (Object)((Object)Versions.getLatest()));
    }
}

