/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.game;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.logging.Level;
import kinugasa.contents.resource.ContentsIOException;
import kinugasa.game.GameLog;

public final class LockUtil {
    public static final String LOCK_FILE_PREFIX = "KTF_";
    public static final String LOCK_FILE_SUFFIX = ".lock";
    public static final FilenameFilter TEMP_FN_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith(LockUtil.LOCK_FILE_PREFIX) & name.endsWith(LockUtil.LOCK_FILE_SUFFIX);
        }
    };
    private static File lockFile;
    private static BufferedWriter writer;

    private LockUtil() {
    }

    static void createLockFile() throws ContentsIOException {
        try {
            lockFile = File.createTempFile(LOCK_FILE_PREFIX, LOCK_FILE_SUFFIX, new File("./"));
            writer = new BufferedWriter(new FileWriter(lockFile));
            writer.append(new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(Calendar.getInstance().getTime()));
            writer.flush();
        }
        catch (IOException ex) {
            GameLog.print(Level.WARNING, ex);
        }
        GameLog.printInfoIfUsing("\u30ed\u30c3\u30af\u30d5\u30a1\u30a4\u30eb " + lockFile.getPath() + " \u304c\u4f5c\u6210\u3055\u308c\u307e\u3057\u305f");
    }

    public static void deleteAllLockFile() {
        File[] list;
        for (File file : list = new File("./").listFiles(TEMP_FN_FILTER)) {
            file.delete();
            GameLog.printInfoIfUsing("\u30ed\u30c3\u30af\u30d5\u30a1\u30a4\u30eb\u3092\u524a\u9664\u3057\u307e\u3057\u305f : " + file.getPath());
        }
    }

    static void deleteLockFile() {
        if (lockFile != null && lockFile.exists()) {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException ex) {
                GameLog.print(Level.WARNING, ex);
            }
            lockFile.delete();
            GameLog.printInfoIfUsing("\u30ed\u30c3\u30af\u30d5\u30a1\u30a4\u30eb " + lockFile.getPath() + " \u306f\u524a\u9664\u3055\u308c\u307e\u3057\u305f");
        }
    }

    static boolean isExistsLockFile() {
        return new File("./").list(TEMP_FN_FILTER).length != 0;
    }

    static String[] listLockFile() {
        return new File("./").list(TEMP_FN_FILTER);
    }
}

