/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.game.logic;

import java.awt.Graphics2D;
import kinugasa.contents.resource.DynamicStorage;
import kinugasa.contents.resource.NameNotFoundException;
import kinugasa.game.logic.GameLogic;
import kinugasa.object.Drawable;

public final class LogicManager
extends DynamicStorage<GameLogic>
implements Drawable {
    private GameLogic currentLogic = null;
    private static final LogicManager INSTANCE = new LogicManager();

    private LogicManager() {
    }

    public static LogicManager getInstance() {
        return INSTANCE;
    }

    public void changeLogic(String name) throws NameNotFoundException {
        this.changeLogic(name, true, true);
    }

    public void changeLogic(String name, boolean free) throws NameNotFoundException {
        this.changeLogic(name, free, true);
    }

    public void changeLogic(String name, boolean free, boolean load) throws NameNotFoundException {
        if (!this.contains(name)) {
            throw new NameNotFoundException("logic not found : name=[" + name + "]");
        }
        if (free && this.currentLogic != null) {
            this.currentLogic.free();
        }
        this.currentLogic = (GameLogic)this.get(name);
        if (load) {
            this.currentLogic.load();
        }
    }

    public void update() {
        this.currentLogic.update();
    }

    @Override
    public void draw(Graphics2D g) {
        this.currentLogic.draw(g);
    }
}

