/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.inputDevice;

import kinugasa.game.PlayerConstants;
import kinugasa.inputDevice.InputDeviceState;
import kinugasa.inputDevice.InputType;
import kinugasa.inputDevice.KeyConnection;
import kinugasa.inputDevice.KeyState;
import kinugasa.inputDevice.Keys;
import kinugasa.inputDevice.MouseButtons;
import kinugasa.inputDevice.MouseConnection;
import kinugasa.inputDevice.MouseState;

public final class InputState
extends InputDeviceState {
    private static final long serialVersionUID = 2349722781837661059L;
    private KeyState keyState = null;
    private KeyState prevKeyState = null;
    private MouseState mouseState = null;
    private MouseState prevMouseState = null;
    private static final InputState INSTANCE = new InputState();

    private InputState() {
        if (PlayerConstants.getInstance().isUsingKeyboard()) {
            this.keyState = KeyConnection.createClearState();
        }
        if (PlayerConstants.getInstance().isUsingMouse()) {
            this.mouseState = MouseConnection.createClearState();
        }
    }

    public static InputState getInstance() {
        INSTANCE.refresh();
        return INSTANCE;
    }

    private void refresh() {
        if (PlayerConstants.getInstance().isUsingMouse()) {
            this.prevMouseState = this.mouseState;
            this.mouseState = MouseConnection.getState();
        }
        if (PlayerConstants.getInstance().isUsingKeyboard()) {
            this.prevKeyState = this.keyState;
            this.keyState = KeyConnection.getState();
        }
    }

    @Override
    public boolean isAnyInput() {
        boolean result = false;
        if (PlayerConstants.getInstance().isUsingMouse()) {
            result |= this.mouseState.isAnyInput();
        }
        return result | this.keyState.isAnyInput();
    }

    @Override
    public boolean isAnyButtonInput() {
        boolean result = false;
        if (PlayerConstants.getInstance().isUsingMouse()) {
            result |= this.mouseState.isAnyButtonInput();
        }
        return result | this.keyState.isAnyButtonInput();
    }

    @Override
    public boolean isEmptyInput() {
        boolean result = true;
        if (PlayerConstants.getInstance().isUsingMouse()) {
            result &= this.mouseState.isEmptyInput();
        }
        return result & this.keyState.isEmptyInput();
    }

    public boolean isPressed(Keys key, InputType type) {
        return type == InputType.CONTINUE ? this.keyState.isPressed(key) : this.keyState.isPressed(key) && !this.prevKeyState.isPressed(key);
    }

    public boolean isPressedOr(InputType type, Keys ... keys) {
        boolean result = false;
        for (Keys key : keys) {
            result |= this.isPressed(key, type);
        }
        return result;
    }

    public boolean isPressedAnd(InputType type, Keys ... keys) {
        for (Keys key : keys) {
            if (this.isPressed(key, type)) continue;
            return false;
        }
        return true;
    }

    public boolean isPressed(MouseButtons button, InputType type) {
        if (!PlayerConstants.getInstance().isUsingMouse()) {
            return false;
        }
        return type == InputType.CONTINUE ? this.mouseState.isPressed(button) : this.mouseState.isPressed(button) && !this.prevMouseState.isPressed(button);
    }

    public KeyState getKeyState() {
        return this.keyState;
    }

    public KeyState getPrevKeyState() {
        return this.prevKeyState;
    }

    public MouseState getPrevMouseState() {
        return this.prevMouseState;
    }

    public MouseState getMouseState() {
        return this.mouseState;
    }

    @Override
    public InputState clone() {
        InputState result = (InputState)super.clone();
        if (this.mouseState != null) {
            result.mouseState = this.mouseState.clone();
        }
        if (this.prevMouseState != null) {
            result.prevMouseState = this.prevMouseState.clone();
        }
        if (this.keyState != null) {
            result.keyState = this.keyState.clone();
        }
        if (this.prevKeyState != null) {
            result.prevKeyState = this.prevKeyState.clone();
        }
        return result;
    }

    public String toString() {
        return "InputState{keyState=" + this.keyState + ", prevKeyState=" + this.prevKeyState + ", mouseState=" + this.mouseState + ", prevMouseState=" + this.prevMouseState + '}';
    }
}

