/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.inputDevice;

import java.util.BitSet;
import kinugasa.inputDevice.InputDeviceState;
import kinugasa.inputDevice.Keys;

public class KeyState
extends InputDeviceState {
    private static final long serialVersionUID = -2099383783403705414L;
    private BitSet keySet;

    KeyState(BitSet state) {
        this.keySet = (BitSet)state.clone();
    }

    public boolean isPressed(Keys k) {
        return this.keySet.get(k.getKeyCode());
    }

    public boolean isPressed(int index) {
        return this.keySet.size() <= index ? false : this.keySet.get(index);
    }

    public String toString() {
        return "KeyState{keySet=" + this.keySet + '}';
    }

    @Override
    public KeyState clone() {
        KeyState result = (KeyState)super.clone();
        result.keySet = (BitSet)this.keySet.clone();
        return result;
    }

    @Override
    public boolean isAnyInput() {
        return !this.keySet.isEmpty();
    }

    @Override
    public boolean isAnyButtonInput() {
        return !this.keySet.isEmpty();
    }

    @Override
    public boolean isEmptyInput() {
        return this.keySet.isEmpty();
    }
}

