/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.inputDevice;

import java.awt.Point;
import java.awt.Shape;
import kinugasa.inputDevice.InputDeviceState;
import kinugasa.inputDevice.MouseButtons;

public final class MouseState
extends InputDeviceState {
    private static final long serialVersionUID = -7984070482396918667L;
    public final boolean LEFT_BUTTON;
    public final boolean RIGHT_BUTTON;
    public final boolean WHEEL_BUTTON;
    public final boolean IN_WINDOW;
    public final boolean DRAG_NOW;
    public final int WHEEL_VALUE;
    private Point location;
    private Point locationOnScreen;
    private static final Point ZERO_POINT = new Point(0, 0);
    private Point draggedLocation;

    MouseState(boolean LEFT_BUTTON, boolean RIGHT_BUTTON, boolean WHEEL_BUTTON, boolean IN_WINDOW, boolean DRAG_NOW, int WHEEL_VALUE, Point location, Point locationOnScreen, Point draggedLocation) {
        this.LEFT_BUTTON = LEFT_BUTTON;
        this.RIGHT_BUTTON = RIGHT_BUTTON;
        this.WHEEL_BUTTON = WHEEL_BUTTON;
        this.IN_WINDOW = IN_WINDOW;
        this.DRAG_NOW = DRAG_NOW;
        this.WHEEL_VALUE = WHEEL_VALUE;
        this.location = (Point)location.clone();
        this.locationOnScreen = (Point)locationOnScreen.clone();
        this.draggedLocation = draggedLocation;
    }

    @Override
    public boolean isAnyInput() {
        return !this.location.equals(ZERO_POINT) || !this.locationOnScreen.equals(ZERO_POINT) || this.LEFT_BUTTON || this.RIGHT_BUTTON || this.WHEEL_BUTTON || this.WHEEL_VALUE != 0 || this.DRAG_NOW;
    }

    @Override
    public boolean isAnyButtonInput() {
        return this.LEFT_BUTTON || this.RIGHT_BUTTON || this.WHEEL_BUTTON;
    }

    @Override
    public boolean isEmptyInput() {
        return this.location.equals(ZERO_POINT) && this.locationOnScreen.equals(ZERO_POINT) && !this.LEFT_BUTTON && !this.RIGHT_BUTTON && !this.WHEEL_BUTTON && this.WHEEL_VALUE == 0 && !this.DRAG_NOW;
    }

    public Point getLocation() {
        return (Point)this.location.clone();
    }

    public int getX() {
        return this.location.x;
    }

    public int getY() {
        return this.location.y;
    }

    public Point getLocationOnScreen() {
        return (Point)this.locationOnScreen.clone();
    }

    public int getXOnScreen() {
        return this.locationOnScreen.x;
    }

    public int getYOnScreen() {
        return this.locationOnScreen.y;
    }

    public boolean contains(Shape shape) {
        return shape == null ? false : this.LEFT_BUTTON & shape.contains(this.location);
    }

    public boolean isPressed(MouseButtons button) {
        switch (button) {
            case LEFT_BUTTON: {
                return this.LEFT_BUTTON;
            }
            case RIGHT_BUTTON: {
                return this.RIGHT_BUTTON;
            }
            case WHEEL_BUTTON: {
                return this.WHEEL_BUTTON;
            }
        }
        throw new AssertionError();
    }

    public Point getDraggedLocation() {
        return (Point)this.draggedLocation.clone();
    }

    public String toString() {
        return "MouseState{LEFT_BUTTON=" + this.LEFT_BUTTON + ", RIGHT_BUTTON=" + this.RIGHT_BUTTON + ", WHEEL_BUTTON=" + this.WHEEL_BUTTON + ", IN_WINDOW=" + this.IN_WINDOW + ", DRAG_NOW=" + this.DRAG_NOW + ", WHEEL_VALUE=" + this.WHEEL_VALUE + ", location=[" + this.location.x + ", " + this.location.y + "], locationOnScreen=[" + this.locationOnScreen.x + ", " + this.locationOnScreen.y + "]}";
    }

    @Override
    public MouseState clone() {
        MouseState result = (MouseState)super.clone();
        result.location = (Point)this.location.clone();
        result.locationOnScreen = (Point)this.locationOnScreen.clone();
        return result;
    }
}

