/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.object;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kinugasa.object.BasicSprite;
import kinugasa.object.MovingModel;
import kinugasa.object.Sprite;
import kinugasa.object.SpriteSortMode;
import kinugasa.object.VectorF;

public class CompositeSprite
extends BasicSprite {
    private static final long serialVersionUID = -6857118666204964110L;
    private ArrayList<Sprite> sprites;

    public CompositeSprite() {
        this(Collections.emptyList());
    }

    public CompositeSprite(Sprite ... spr) {
        this(Arrays.asList(spr));
    }

    public CompositeSprite(List<Sprite> spr) {
        this.sprites = new ArrayList(spr.size());
        this.addAll(spr.toArray(new Sprite[spr.size()]));
    }

    public void add(Sprite spr) throws IllegalArgumentException {
        if (spr instanceof CompositeSprite) {
            this.checkInstance(Arrays.asList(this), Arrays.asList(spr));
        }
        this.sprites.add(spr);
    }

    public void addAll(Sprite ... spr) throws IllegalArgumentException {
        for (Sprite s : spr) {
            this.add(s);
        }
    }

    public void addAll(List<Sprite> spr) throws IllegalArgumentException {
        this.addAll(spr.toArray(new Sprite[spr.size()]));
    }

    public void remove(Sprite spr) {
        this.sprites.remove(spr);
    }

    public void removeAll(Sprite ... spr) {
        this.sprites.removeAll(Arrays.asList(spr));
    }

    public void removeAll(List<Sprite> spr) {
        this.removeAll(spr.toArray(new Sprite[spr.size()]));
    }

    public boolean contains(Sprite spr) {
        return this.sprites.contains(spr);
    }

    public void sortZ(float minZ, float maxZ) throws IllegalArgumentException {
        if (minZ > maxZ) {
            throw new IllegalArgumentException("min > max : minZ=[" + minZ + "] maxZ=[" + maxZ + "]");
        }
        float z = minZ;
        float addZ = (maxZ - minZ) / (float)this.sprites.size();
        for (int i = 0; i < this.sprites.size(); ++i) {
            this.sprites.get(i).setZ(z + addZ * (float)i);
        }
        this.sort();
    }

    public void clear() {
        this.sprites.clear();
    }

    public List<Sprite> getSprites() {
        return this.sprites;
    }

    public Sprite getSprite(int idx) throws IndexOutOfBoundsException {
        return this.sprites.get(idx);
    }

    public int size() {
        return this.sprites.size();
    }

    private void checkInstance(List<CompositeSprite> parents, List<Sprite> sprites) throws IllegalArgumentException {
        int size = sprites.size();
        for (int i = 0; i < size; ++i) {
            Sprite spr = sprites.get(i);
            if (!(spr instanceof CompositeSprite)) continue;
            CompositeSprite newParent = (CompositeSprite)spr;
            int parentSize = parents.size();
            for (int j = 0; j < parentSize; ++j) {
                if (spr != parents.get(j)) continue;
                throw new IllegalArgumentException("found loop reference : sprite=[" + spr + "]");
            }
            ArrayList<CompositeSprite> newParents = new ArrayList<CompositeSprite>(parents);
            newParents.add(newParent);
            this.checkInstance(newParents, newParent.sprites);
        }
    }

    @Override
    public void draw(Graphics2D g) {
        if (!this.isVisible() || !this.isExist()) {
            return;
        }
        int size = this.sprites.size();
        for (int i = 0; i < size; ++i) {
            this.sprites.get(i).draw(g);
        }
    }

    public void draw(Graphics2D g, Comparator<Sprite> sortMode) {
        this.sort(sortMode);
        this.draw(g);
    }

    public void sort(Comparator<Sprite> sortMode) {
        this.deepSort(this.sprites, sortMode);
    }

    public void sort() {
        this.sort(SpriteSortMode.BACK_TO_FRONT);
    }

    private void deepSort(List<Sprite> sprs, Comparator<Sprite> sortMode) {
        int size = sprs.size();
        for (int i = 0; i < size; ++i) {
            Sprite spr = sprs.get(i);
            if (!(spr instanceof CompositeSprite)) continue;
            this.deepSort(((CompositeSprite)spr).sprites, sortMode);
        }
        Collections.sort(sprs, sortMode);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        int size = this.sprites.size();
        for (int i = 0; i < size; ++i) {
            this.sprites.get(i).setVisible(visible);
        }
    }

    @Override
    public void setExist(boolean exist) {
        super.setExist(exist);
        int size = this.sprites.size();
        for (int i = 0; i < size; ++i) {
            this.sprites.get(i).setExist(exist);
        }
    }

    @Override
    public void setZ(float z) {
        super.setZ(z);
    }

    public void setZ(float z, int idx) throws IndexOutOfBoundsException {
        this.sprites.get(idx).setZ(z);
    }

    @Override
    public void setX(float x) {
        super.setX(x);
        int size = this.sprites.size();
        for (int i = 0; i < size; ++i) {
            this.sprites.get(i).setX(x);
        }
    }

    @Override
    public void setY(float y) {
        super.setY(y);
        int size = this.sprites.size();
        for (int i = 0; i < size; ++i) {
            this.sprites.get(i).setY(y);
        }
    }

    @Override
    public void setWidth(float width) {
        super.setWidth(width);
        int size = this.sprites.size();
        for (int i = 0; i < size; ++i) {
            this.sprites.get(i).setWidth(width);
        }
    }

    @Override
    public void setHeight(float height) {
        super.setHeight(height);
        int size = this.sprites.size();
        for (int i = 0; i < size; ++i) {
            this.sprites.get(i).setHeight(height);
        }
    }

    @Override
    public void setLocation(Point2D.Float location) {
        super.setLocation(location);
        int size = this.sprites.size();
        for (int i = 0; i < size; ++i) {
            this.sprites.get(i).setLocation(location);
        }
    }

    @Override
    public void setLocation(float x, float y) {
        super.setLocation(x, y);
        int size = this.sprites.size();
        for (int i = 0; i < size; ++i) {
            this.sprites.get(i).setLocation(x, y);
        }
    }

    @Override
    public void setSize(float w, float h) {
        super.setSize(w, h);
        int size = this.sprites.size();
        for (int i = 0; i < size; ++i) {
            this.sprites.get(i).setSize(w, h);
        }
    }

    @Override
    public void setSize(Dimension size) {
        super.setSize(size);
        int sprSize = this.sprites.size();
        for (int i = 0; i < sprSize; ++i) {
            this.sprites.get(i).setSize(size);
        }
    }

    @Override
    public void setBounds(Rectangle2D.Float bounds) {
        super.setBounds(bounds);
        int sprSize = this.sprites.size();
        for (int i = 0; i < sprSize; ++i) {
            this.sprites.get(i).setBounds(bounds);
        }
    }

    @Override
    public void setAngle(float angle) {
        super.setAngle(angle);
        int sprSize = this.sprites.size();
        for (int i = 0; i < sprSize; ++i) {
            if (!(this.sprites.get(i) instanceof BasicSprite)) continue;
            ((BasicSprite)this.sprites.get(i)).setAngle(angle);
        }
    }

    @Override
    public void setMovingModel(MovingModel movingModel) {
        super.setMovingModel(movingModel);
        int sprSize = this.sprites.size();
        for (int i = 0; i < sprSize; ++i) {
            if (!(this.sprites.get(i) instanceof BasicSprite)) continue;
            ((BasicSprite)this.sprites.get(i)).setMovingModel(movingModel);
        }
    }

    @Override
    public void setVector(VectorF vector) {
        super.setVector(vector);
        int sprSize = this.sprites.size();
        for (int i = 0; i < sprSize; ++i) {
            if (!(this.sprites.get(i) instanceof BasicSprite)) continue;
            ((BasicSprite)this.sprites.get(i)).setVector(vector);
        }
    }

    @Override
    public void setSpeed(float speed) {
        super.setSpeed(speed);
        int sprSize = this.sprites.size();
        for (int i = 0; i < sprSize; ++i) {
            if (!(this.sprites.get(i) instanceof BasicSprite)) continue;
            ((BasicSprite)this.sprites.get(i)).setSpeed(speed);
        }
    }

    public <T extends Sprite> List<Sprite> subList(Class<T> type) {
        ArrayList<Sprite> result = new ArrayList<Sprite>();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Sprite sprite = this.getSprite(i);
            if (!type.equals(sprite.getClass())) continue;
            result.add(this.getSprite(i));
        }
        return result;
    }

    @Override
    public CompositeSprite clone() {
        CompositeSprite sprite = (CompositeSprite)super.clone();
        sprite.sprites = (ArrayList)this.sprites.clone();
        return sprite;
    }

    @Override
    public String toString() {
        return "CompositeSprite{sprites=" + this.sprites + '}';
    }
}

