/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.object;

import java.awt.Color;
import java.awt.Graphics2D;
import kinugasa.contents.graphics.GraphicsUtil;
import kinugasa.object.ScreenEffect;
import kinugasa.util.TimeCounter;

public class FlashEffect
extends ScreenEffect {
    private static final long serialVersionUID = -8073668873650281855L;
    private Color color;
    private TimeCounter blinkRate;
    private TimeCounter flashTime;
    private boolean ended = false;
    private boolean running = false;

    public FlashEffect(Color color, TimeCounter blinkRate, TimeCounter flashTime, float x, float y, float w, float h) {
        super(x, y, w, h);
        this.color = color;
        this.blinkRate = blinkRate;
        this.flashTime = flashTime;
    }

    @Override
    public void draw(Graphics2D g) {
        if (!this.isVisible() || !this.isExist()) {
            return;
        }
        if (this.ended) {
            return;
        }
        this.running = true;
        if (this.blinkRate.isReaching()) {
            g.setColor(this.color);
            GraphicsUtil.fillRect(g, this.getBounds());
        }
        if (this.flashTime.isReaching()) {
            this.ended = true;
        }
    }

    @Override
    public boolean isEnded() {
        return this.ended;
    }

    @Override
    public void reset() {
        this.blinkRate.reset();
        this.flashTime.reset();
        this.ended = false;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }
}

