/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.object;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import kinugasa.contents.resource.Nameable;
import kinugasa.object.Drawable;
import kinugasa.object.Shapeable;

public abstract class Sprite
implements Drawable,
Shapeable,
Cloneable,
Comparable<Sprite>,
Serializable,
Nameable {
    private static final long serialVersionUID = -5402705971209018799L;
    private Rectangle2D.Float bounds;
    private Point2D.Float center = null;
    private Point2D.Float personalCenter = null;
    private float z = 0.0f;
    private boolean visible = true;
    private boolean exist = true;
    private String name;

    private void setCenter() {
        this.center = new Point2D.Float(this.bounds.x + this.bounds.width / 2.0f, this.bounds.y + this.bounds.height / 2.0f);
        this.personalCenter = new Point2D.Float(this.bounds.width / 2.0f, this.bounds.height / 2.0f);
    }

    protected final void updateCenter() {
        this.center.x = this.bounds.x + this.personalCenter.x;
        this.center.y = this.bounds.y + this.personalCenter.y;
    }

    protected final void updatePersonalCenter() {
        this.personalCenter.x = this.bounds.width / 2.0f;
        this.personalCenter.y = this.bounds.height / 2.0f;
    }

    public Sprite() {
        this.bounds = new Rectangle2D.Float();
        this.setCenter();
    }

    private Sprite(Rectangle2D.Float bounds) {
        this.bounds = bounds;
        this.z = 0.0f;
        this.setCenter();
    }

    public Sprite(float x, float y, float w, float h) {
        this(x, y, w, h, 0.0f);
    }

    public Sprite(float x, float y, float w, float h, float z) {
        this.bounds = new Rectangle2D.Float(x, y, w, h);
        this.z = z;
        this.setCenter();
    }

    @Override
    public abstract void draw(Graphics2D var1);

    public void update() {
    }

    public Rectangle2D.Float getBounds() {
        return (Rectangle2D.Float)this.bounds.clone();
    }

    public Rectangle2D.Float getHitBounds() {
        return (Rectangle2D.Float)this.bounds.clone();
    }

    public void setBounds(Rectangle2D.Float bounds) {
        this.bounds = bounds;
        this.updatePersonalCenter();
        this.updateCenter();
    }

    public void setBounds(Point2D.Float location, float width, float height) {
        this.setBounds(new Rectangle2D.Float(location.x, location.y, width, height));
    }

    public void setBounds(float x, float y, float width, float height) {
        this.setBounds(new Rectangle2D.Float(x, y, width, height));
    }

    @Override
    public boolean contains(Point2D point) {
        return this.bounds.contains(point);
    }

    public Point2D.Float getLocation() {
        return new Point2D.Float(this.bounds.x, this.bounds.y);
    }

    public void setLocation(Point2D.Float location) {
        this.setLocation(location.x, location.y);
    }

    public void setLocation(float x, float y) {
        this.setX(x);
        this.setY(y);
    }

    public Point2D.Float getCenter() {
        return (Point2D.Float)this.center.clone();
    }

    public float getCenterX() {
        return this.center.x;
    }

    public float getCenterY() {
        return this.center.y;
    }

    public float getPersonalCenterX() {
        return this.personalCenter.x;
    }

    public float getPersonalCenterY() {
        return this.personalCenter.y;
    }

    public Point2D.Float getPersonalCenter() {
        return (Point2D.Float)this.personalCenter.clone();
    }

    public Dimension getSize() {
        return new Dimension((int)this.bounds.width, (int)this.bounds.height);
    }

    public void setSize(Dimension size) {
        this.setSize(size.width, size.height);
    }

    public void setSize(float w, float h) {
        this.bounds.width = w;
        this.bounds.height = h;
        this.updatePersonalCenter();
        this.updateCenter();
    }

    public boolean isExist() {
        return this.exist;
    }

    public void setExist(boolean exist) {
        this.exist = exist;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public float getX() {
        return this.bounds.x;
    }

    public void setX(float x) {
        this.bounds.x = x;
        this.center.x = this.bounds.x + this.personalCenter.x;
    }

    public float getY() {
        return this.bounds.y;
    }

    public void setY(float y) {
        this.bounds.y = y;
        this.center.y = this.bounds.y + this.personalCenter.y;
    }

    public float getWidth() {
        return this.bounds.width;
    }

    public void setWidth(float width) {
        this.bounds.width = width;
        this.personalCenter.x = this.bounds.width / 2.0f;
        this.center.x = this.bounds.x + this.personalCenter.x;
    }

    public float getHeight() {
        return this.bounds.height;
    }

    public void setHeight(float height) {
        this.bounds.height = height;
        this.personalCenter.y = this.bounds.height / 2.0f;
        this.center.y = this.bounds.y + this.personalCenter.y;
    }

    public float getZ() {
        return this.z;
    }

    public void setZ(float z) {
        this.z = z;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Sprite clone() {
        try {
            Sprite s = (Sprite)super.clone();
            s.bounds = (Rectangle2D.Float)this.bounds.clone();
            s.center = (Point2D.Float)this.center.clone();
            s.personalCenter = (Point2D.Float)this.personalCenter.clone();
            return s;
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(Sprite.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public final int compareTo(Sprite spr) {
        return Float.compare(this.z, spr.z);
    }

    public String toString() {
        return "Sprite{bounds=" + this.bounds + ", center=" + this.center + ", personalCenter=" + this.personalCenter + ", z=" + this.z + ", visible=" + this.visible + ", exist=" + this.exist + '}';
    }
}

