/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.object.movingModel;

import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.List;
import kinugasa.object.BasicSprite;
import kinugasa.object.MovingModel;
import kinugasa.object.Sprite;
import kinugasa.util.TimeCounter;

public class Track
extends MovingModel {
    private static final long serialVersionUID = -3072225639770210935L;
    private List<Sprite> targetList;
    private Sprite currentTarget;
    private TimeCounter updateTargetDelay;

    public Track(List<Sprite> targetList, TimeCounter updateTargetDelay) {
        this.targetList = targetList;
        this.updateTargetDelay = updateTargetDelay;
    }

    public Track(Sprite target, TimeCounter updateTargetDelay) {
        this(Arrays.asList(target), updateTargetDelay);
    }

    public Track(Sprite target) {
        this(Arrays.asList(target), TimeCounter.FALSE);
        this.currentTarget = target;
    }

    public List<Sprite> getTargetList() {
        return this.targetList;
    }

    public void setTargetList(List<Sprite> targetList) {
        this.targetList = targetList;
    }

    public Sprite getCurrentTarget() {
        return this.currentTarget;
    }

    public void setCurrentTarget(Sprite currentTarget) {
        this.currentTarget = currentTarget;
    }

    public TimeCounter getUpdateTargetDelay() {
        return this.updateTargetDelay;
    }

    public void setUpdateTargetDelay(TimeCounter updateTargetDelay) {
        this.updateTargetDelay = updateTargetDelay;
    }

    public void serachMostNearTarget(BasicSprite sprite) {
        Point2D.Float spriteCenter = sprite.getCenter();
        double distance = this.currentTarget == null ? Double.POSITIVE_INFINITY : spriteCenter.distance(this.currentTarget.getCenter());
        int size = this.targetList.size();
        for (int i = 0; i < size; ++i) {
            double candidateDistance = spriteCenter.distance(this.targetList.get(i).getCenter());
            if (!(candidateDistance < distance)) continue;
            distance = candidateDistance;
            this.currentTarget = this.targetList.get(i);
        }
    }

    @Override
    public void move(BasicSprite s) {
        if (this.updateTargetDelay.isReaching()) {
            this.serachMostNearTarget(s);
        }
        if (this.currentTarget == null) {
            return;
        }
        s.getVector().setAngle(s.getCenter(), this.currentTarget.getCenter());
    }

    @Override
    public Track clone() {
        Track clone = (Track)super.clone();
        clone.updateTargetDelay = this.updateTargetDelay.clone();
        return clone;
    }
}

