/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.rpgui;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kinugasa.contents.resource.Disposable;
import kinugasa.contents.sound.SoundMap;
import kinugasa.game.GameLog;
import kinugasa.object.BasicSprite;
import kinugasa.object.MovingModel;
import kinugasa.object.VectorF;
import kinugasa.rpgui.BackgroundLayerSprite;
import kinugasa.rpgui.ChipAttribute;
import kinugasa.rpgui.FieldMapBuilder;
import kinugasa.rpgui.FieldMapLayer;
import kinugasa.rpgui.MapChip;
import kinugasa.rpgui.NodeMap;
import kinugasa.rpgui.Vehicle;
import kinugasa.rpgui.VehicleStorage;

public class FieldMap
extends BasicSprite
implements Iterable<FieldMapLayer>,
Disposable {
    private static final long serialVersionUID = -6273256850976425790L;
    private BackgroundLayerSprite backgroundLayerSprite;
    private List<FieldMapLayer> fieldMapLayers;
    private FieldMapBuilder fieldMapBuilder;

    public FieldMap(FieldMapBuilder fieldMapBuilder, BackgroundLayerSprite backgroundLayerSprite, List<FieldMapLayer> fieldMapLayers) {
        this.fieldMapBuilder = fieldMapBuilder;
        this.backgroundLayerSprite = backgroundLayerSprite;
        this.fieldMapLayers = fieldMapLayers;
    }

    public FieldMap(FieldMapBuilder fieldMapBuilder, BackgroundLayerSprite backgroundLayerSprite, FieldMapLayer ... fieldMapLayers) {
        this(fieldMapBuilder, backgroundLayerSprite, Arrays.asList(fieldMapLayers));
    }

    public List<MapChip> getChip(int x, int y) throws ArrayIndexOutOfBoundsException {
        ArrayList<MapChip> result = new ArrayList<MapChip>();
        int size = this.fieldMapLayers.size();
        for (int i = 0; i < size; ++i) {
            MapChip[] chips = this.fieldMapLayers.get(i).getMapLayerSprite().getChip(x, y);
            result.addAll(Arrays.asList(chips));
        }
        return result;
    }

    public List<ChipAttribute> getAttribute(int x, int y) throws ArrayIndexOutOfBoundsException {
        List<MapChip> mapChipList = this.getChip(x, y);
        ArrayList<ChipAttribute> result = new ArrayList<ChipAttribute>(mapChipList.size());
        int size = this.fieldMapLayers.size();
        for (int i = 0; i < size; ++i) {
            result.add(mapChipList.get(i).getAttribute());
        }
        return result;
    }

    public boolean stepOn(int x, int y) {
        return this.stepOn(VehicleStorage.getInstance().getCurrentVehicle(), x, y);
    }

    public boolean stepOn(Vehicle vehicle, int x, int y) {
        if (vehicle == null) {
            return true;
        }
        for (ChipAttribute attribute : this.getAttribute(x, y)) {
            if (vehicle.stepOn(attribute)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void dispose() {
        this.backgroundLayerSprite.dispose();
        int size = this.fieldMapLayers.size();
        for (int i = 0; i < size; ++i) {
            this.fieldMapLayers.get(i).dispose();
        }
        GameLog.printInfo("\u30d5\u30a3\u30fc\u30eb\u30c9\u30de\u30c3\u30d7\u304c\u7834\u68c4\u3055\u308c\u307e\u3057\u305f name=[" + this.getName() + "]");
        this.fieldMapBuilder.free();
    }

    @Override
    public void draw(Graphics2D g2) {
        if (!this.isVisible() || !this.isExist()) {
            return;
        }
        this.backgroundLayerSprite.draw(g2);
        int size = this.fieldMapLayers.size();
        for (int i = 0; i < size; ++i) {
            this.fieldMapLayers.get(i).draw(g2);
        }
    }

    public BackgroundLayerSprite getBackgroundLayerSprite() {
        return this.backgroundLayerSprite;
    }

    public List<FieldMapLayer> getFieldMapLayers() {
        return this.fieldMapLayers;
    }

    public FieldMapBuilder getFieldMapBuilder() {
        return this.fieldMapBuilder;
    }

    public SoundMap getSoundMap() {
        return this.fieldMapBuilder.getSoundMap();
    }

    public NodeMap getNodeMap() {
        return this.fieldMapBuilder.getNodeMap();
    }

    public int getChipWidth() {
        return this.fieldMapBuilder.getChipWidth();
    }

    public int getChipHeight() {
        return this.fieldMapBuilder.getChipHeight();
    }

    @Override
    public void move() {
        super.move();
    }

    @Override
    public void move(MovingModel m) {
        super.move(m);
    }

    @Override
    public boolean move(Point2D.Float p, Shape s) {
        return super.move(p, s);
    }

    @Override
    public boolean move(float xValue, float yValue, Shape s) {
        return super.move(xValue, yValue, s);
    }

    @Override
    public void setLocation(Point2D.Float location) {
        super.setLocation(location);
    }

    @Override
    public void setLocation(float x, float y) {
        super.setLocation(x, y);
    }

    @Override
    public void setX(float x) {
        super.setX(x);
    }

    @Override
    public void setY(float y) {
        super.setY(y);
    }

    @Override
    public void setAngle(float angle) {
        super.setAngle(angle);
    }

    @Override
    public void setSpeed(float speed) {
        super.setSpeed(speed);
    }

    @Override
    public void setVector(VectorF vector) {
        super.setVector(vector);
    }

    @Override
    public void setBounds(Rectangle2D.Float bounds) {
        super.setBounds(bounds);
    }

    @Override
    public void setBounds(Point2D.Float location, float width, float height) {
        super.setBounds(location, width, height);
    }

    @Override
    public void setBounds(float x, float y, float width, float height) {
        super.setBounds(x, y, width, height);
    }

    @Override
    public void setMovingModel(MovingModel movingModel) {
        super.setMovingModel(movingModel);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    @Override
    public String toString() {
        return "FieldMapLayerList{backgroundLayerSprite=" + this.backgroundLayerSprite + ", fieldMapLayers=" + this.fieldMapLayers + '}';
    }

    @Override
    public Iterator<FieldMapLayer> iterator() {
        return this.fieldMapLayers.iterator();
    }
}

