/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.rpgui;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import kinugasa.contents.graphics.ImageUtil;
import kinugasa.contents.resource.ContentsIOException;
import kinugasa.contents.text.CSVReader;
import kinugasa.contents.text.CSVWriter;
import kinugasa.game.GameLog;

public class FieldMapResourceUtil {
    public static void platinumCsvType1ToKGCsv(File input, File output) throws ContentsIOException {
        if (!input.exists() | output.exists()) {
            throw new ContentsIOException("File is Already Exists");
        }
        CSVReader reader = new CSVReader(input);
        CSVWriter writer = new CSVWriter(output);
        String[] convertTable = new String[65536];
        int k = 0;
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                String y = Integer.toString(i);
                while (y.length() != 3) {
                    y = "0" + y;
                }
                String x = Integer.toString(j);
                while (x.length() != 3) {
                    x = "0" + x;
                }
                convertTable[k++] = y + x;
            }
        }
        ArrayList inputData = reader.load().getData();
        for (String[] inputLine : inputData) {
            String[] outputLine = new String[inputLine.length];
            for (int j = 0; j < inputLine.length; ++j) {
                outputLine[j] = convertTable[Integer.parseInt(inputLine[j])];
            }
            writer.add(outputLine);
        }
        reader.free();
        writer.save();
        GameLog.printInfo("\u5909\u63db\u306f\u6b63\u5e38\u306b\u7d42\u4e86\u3057\u307e\u3057\u305f");
    }

    public static void printImageId(String filePath, int w, int h) {
        BufferedImage image = ImageUtil.load(filePath);
        Map<String, BufferedImage> map = ImageUtil.splitAsMapN(image, w, h, 3);
        ArrayList<String> keyList = new ArrayList<String>(map.keySet());
        Collections.sort(keyList);
        int size = keyList.size();
        for (int i = 0; i < size; ++i) {
            System.out.println((String)keyList.get(i));
        }
    }
}

