/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.rpgui;

import java.awt.Point;
import kinugasa.contents.resource.Nameable;
import kinugasa.object.FourDirection;
import kinugasa.rpgui.NodeAccepter;

public class Node
implements Nameable {
    private final String name;
    private final Point location;
    private final String exitMapName;
    private final String exitNodeName;
    private final FourDirection face;
    private String tooltip;
    private NodeAccepter accepter;

    public Node(String name, Point location, String exitMapName, String exitNodeName, FourDirection face) {
        this(name, location, exitMapName, exitNodeName, "", face);
    }

    public Node(String name, Point location, String exitMapName, String exitNodeName, String tooltip, FourDirection face) {
        this(name, location, exitMapName, exitNodeName, tooltip, face, null);
    }

    public Node(String name, Point location, String exitMapName, String exitNodeName, String tooltip, FourDirection face, NodeAccepter accepter) {
        this.name = name;
        this.location = location;
        this.exitMapName = exitMapName;
        this.exitNodeName = exitNodeName;
        this.tooltip = tooltip;
        this.face = face;
        this.accepter = accepter;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public int getX() {
        return this.location.x;
    }

    public int getY() {
        return this.location.y;
    }

    public void setAccepter(NodeAccepter accepter) {
        this.accepter = accepter;
    }

    public String getExitMapName() {
        return this.exitMapName;
    }

    public String getExitNodeName() {
        return this.exitNodeName;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public FourDirection getFace() {
        return this.face;
    }

    public NodeAccepter getAccepter() {
        return this.accepter;
    }

    public boolean hasAccepter() {
        return this.accepter != null;
    }

    public boolean accept() {
        return this.hasAccepter() ? this.accepter.accept() : true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Point getLocation() {
        return this.location;
    }

    public String toString() {
        return "Node{name=" + this.name + ", location=" + this.location + ", exitMapName=" + this.exitMapName + ", exitNodeName=" + this.exitNodeName + ", face=" + (Object)((Object)this.face) + ", tooltip=" + this.tooltip + ", accepter=" + this.accepter + '}';
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

