/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.rpgui;

import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import kinugasa.contents.graphics.Animation;
import kinugasa.contents.graphics.ImageUtil;
import kinugasa.contents.graphics.SpriteSheet;
import kinugasa.contents.resource.IllegalXMLFormatException;
import kinugasa.contents.resource.NameNotFoundException;
import kinugasa.contents.resource.NotYetLoadedException;
import kinugasa.contents.resource.ReflectionClassNotFoundException;
import kinugasa.contents.sound.SoundMap;
import kinugasa.contents.text.XMLAttribute;
import kinugasa.contents.text.XMLAttributeStorage;
import kinugasa.contents.text.XMLElement;
import kinugasa.contents.text.XMLReader;
import kinugasa.game.GameLog;
import kinugasa.object.AnimationSprite;
import kinugasa.object.ImagePainter;
import kinugasa.object.ImagePainterStorage;
import kinugasa.object.ImageSprite;
import kinugasa.object.Sprite;
import kinugasa.rpgui.BackgroundLayerSprite;
import kinugasa.rpgui.CSVMapData;
import kinugasa.rpgui.ChipSet;
import kinugasa.rpgui.ChipSetStorage;
import kinugasa.rpgui.FieldMap;
import kinugasa.rpgui.FieldMapBuilder;
import kinugasa.rpgui.FieldMapBuilderStorage;
import kinugasa.rpgui.FieldMapLayer;
import kinugasa.rpgui.MapData;
import kinugasa.rpgui.MapLayerSprite;
import kinugasa.rpgui.MessageWindowSprite;
import kinugasa.rpgui.NodeMap;
import kinugasa.rpgui.ObjectLayerSprite;
import kinugasa.rpgui.TextStorage;
import kinugasa.util.FrameTimeCounter;
import kinugasa.util.StopWatch;
import kinugasa.util.StringUtil;
import kinugasa.util.TimeCounter;

public final class XMLFieldMapBuilder
implements FieldMapBuilder {
    private String name;
    private SoundMap soundMap;
    private NodeMap nodeMap;
    private XMLReader dataFileReader;
    private boolean loaded = false;
    private int chipWidth;
    private int chipHeight;
    private FieldMap fieldMap;
    private TextStorage textStorage;
    private int x;
    private int y;
    private String textDataPath;

    public XMLFieldMapBuilder(String name, SoundMap soundMap, NodeMap nodeMap, XMLReader dataFileReader, String textDataPath, int x, int y) {
        this.name = name;
        this.soundMap = soundMap;
        this.nodeMap = nodeMap;
        this.dataFileReader = dataFileReader;
        this.x = x;
        this.y = y;
        this.textDataPath = textDataPath;
        this.addThis();
    }

    private void addThis() {
        FieldMapBuilderStorage.getInstance().add(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public FieldMap getFieldMap() throws NotYetLoadedException {
        if (!this.isLoaded()) {
            GameLog.print(Level.WARNING, "FieldMap\u304c\u8981\u6c42\u3055\u308c\u307e\u3057\u305f\u304c\u3001\u30ed\u30fc\u30c9\u3055\u308c\u3066\u3044\u307e\u305b\u3093 " + this);
            throw new NotYetLoadedException("fieldMapBuilder : " + this + " is not yet loaded.");
        }
        return this.fieldMap;
    }

    @Override
    public XMLFieldMapBuilder load() throws IllegalXMLFormatException, NumberFormatException, NameNotFoundException, RasterFormatException, ReflectionClassNotFoundException {
        StopWatch watch = new StopWatch().start();
        this.dataFileReader.load();
        XMLElement root = (XMLElement)this.dataFileReader.getFirst();
        if (!"kinugasaFieldMapData".equals(root.getName())) {
            GameLog.print(Level.WARNING, "\u30eb\u30fc\u30c8\u30ce\u30fc\u30c9\u304c\u4e0d\u6b63\u3067\u3059 " + this.dataFileReader);
            throw new IllegalXMLFormatException("illegal root node name : " + root);
        }
        this.chipWidth = ((XMLAttribute)root.getAttributes().get("chipWidth")).getIntValue();
        this.chipHeight = ((XMLAttribute)root.getAttributes().get("chipHeight")).getIntValue();
        this.fieldMap = this.parseLayer(root.getElement("layer"), root.getElement("background"));
        this.fieldMap.setX(this.x);
        this.fieldMap.setY(this.y);
        this.fieldMap.setName(this.name);
        this.dataFileReader.free();
        if (this.textDataPath != null) {
            this.textStorage = new TextStorage();
            this.textStorage.readFromXML(this.textDataPath);
        }
        this.loaded = true;
        watch.stop();
        GameLog.printInfo("\u30d5\u30a3\u30fc\u30eb\u30c9\u30de\u30c3\u30d7\u30c7\u30fc\u30bf\u304c\u69cb\u7bc9\u3055\u308c\u307e\u3057\u305f name=[" + this.getName() + "] (" + watch.getTime() + " ms)");
        return this;
    }

    private FieldMap parseLayer(List<XMLElement> layerElements, List<XMLElement> backgroundElements) throws IllegalXMLFormatException, NameNotFoundException, ReflectionClassNotFoundException, RasterFormatException {
        ArrayList<FieldMapLayer> fieldMapLayer = new ArrayList<FieldMapLayer>(layerElements.size());
        int layerElementSize = layerElements.size();
        for (int i = 0; i < layerElementSize; ++i) {
            XMLElement layerElement = layerElements.get(i);
            fieldMapLayer.add(new FieldMapLayer(((XMLAttribute)layerElement.getAttributes().get("z")).getFloatValue(), ((XMLAttribute)layerElement.getAttributes().get("speed")).getFloatValue(), new ObjectLayerSprite(this.parseAnySprite(layerElement)), this.parseMap(layerElement)));
        }
        Collections.sort(fieldMapLayer);
        return new FieldMap((FieldMapBuilder)this, this.parseBackground(backgroundElements), fieldMapLayer);
    }

    private List<Sprite> parseAnySprite(XMLElement parent) throws IllegalXMLFormatException, RasterFormatException, ReflectionClassNotFoundException {
        ArrayList<Sprite> result = new ArrayList<Sprite>();
        result.addAll(this.parseSprite(parent.getElement("sprite")));
        result.addAll(this.parseImageSprite(parent.getElement("imageSprite")));
        result.addAll(this.parseAnimationSprite(parent.getElement("animationSprite")));
        return result;
    }

    private List<Sprite> parseSprite(List<XMLElement> spriteElement) throws NumberFormatException, ReflectionClassNotFoundException {
        if (spriteElement == null) {
            return Collections.emptyList();
        }
        ArrayList<Sprite> result = new ArrayList<Sprite>(spriteElement.size());
        int size = spriteElement.size();
        for (int i = 0; i < size; ++i) {
            Sprite sprite;
            XMLElement element = spriteElement.get(i);
            XMLAttributeStorage attr = element.getAttributes();
            int x = this.chipWidth * ((XMLAttribute)attr.get("chipX")).getIntValue();
            int y = this.chipHeight * ((XMLAttribute)attr.get("chipY")).getIntValue();
            float width = ((XMLAttribute)attr.get("width")).getFloatValue();
            float height = ((XMLAttribute)attr.get("height")).getFloatValue();
            try {
                Class<?> type = Class.forName(((XMLAttribute)attr.get("class")).getValue());
                sprite = (Sprite)type.newInstance();
            }
            catch (ClassNotFoundException ex) {
                throw new ReflectionClassNotFoundException(ex);
            }
            catch (InstantiationException ex) {
                throw new ReflectionClassNotFoundException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new ReflectionClassNotFoundException(ex);
            }
            if (sprite == null) {
                throw new ReflectionClassNotFoundException("reflection failed");
            }
            sprite.setBounds(x, y, width, height);
            sprite.setVisible(attr.contains("visible") ? ((XMLAttribute)attr.get("visible")).getBool() : true);
            sprite.setExist(attr.contains("exist") ? ((XMLAttribute)attr.get("exist")).getBool() : true);
            result.add(sprite);
        }
        return result;
    }

    private List<Sprite> parseImageSprite(List<XMLElement> spriteElement) throws NumberFormatException, RasterFormatException, NameNotFoundException {
        if (spriteElement == null) {
            return Collections.emptyList();
        }
        ArrayList<Sprite> result = new ArrayList<Sprite>(spriteElement.size());
        int size = spriteElement.size();
        for (int i = 0; i < size; ++i) {
            XMLElement element = spriteElement.get(i);
            XMLAttributeStorage attr = element.getAttributes();
            int x = this.chipWidth * ((XMLAttribute)attr.get("chipX")).getIntValue();
            int y = this.chipHeight * ((XMLAttribute)attr.get("chipY")).getIntValue();
            float width = ((XMLAttribute)attr.get("width")).getFloatValue();
            float height = ((XMLAttribute)attr.get("height")).getFloatValue();
            BufferedImage image = this.parseImages(element)[0];
            ImagePainter painter = attr.contains("painterName") ? (ImagePainter)ImagePainterStorage.getInstance().get(((XMLAttribute)attr.get("painterName")).getValue()) : ImagePainterStorage.IMAGE_BOUNDS_XY;
            ImageSprite sprite = new ImageSprite((float)x, (float)y, width, height, image, painter);
            sprite.setVisible(attr.contains("visible") ? ((XMLAttribute)attr.get("visible")).getBool() : true);
            sprite.setExist(attr.contains("exist") ? ((XMLAttribute)attr.get("exist")).getBool() : true);
            result.add(sprite);
        }
        return result;
    }

    private List<Sprite> parseAnimationSprite(List<XMLElement> spriteElement) {
        if (spriteElement == null) {
            return Collections.emptyList();
        }
        ArrayList<Sprite> result = new ArrayList<Sprite>(spriteElement.size());
        int size = spriteElement.size();
        for (int i = 0; i < size; ++i) {
            XMLElement element = spriteElement.get(i);
            XMLAttributeStorage attr = element.getAttributes();
            int x = this.chipWidth * ((XMLAttribute)attr.get("chipX")).getIntValue();
            int y = this.chipHeight * ((XMLAttribute)attr.get("chipY")).getIntValue();
            float width = ((XMLAttribute)attr.get("width")).getFloatValue();
            float height = ((XMLAttribute)attr.get("height")).getFloatValue();
            FrameTimeCounter timeCounter = new FrameTimeCounter(StringUtil.parseIntCSV(((XMLAttribute)attr.get("frame")).getValue()));
            BufferedImage[] image = this.parseImages(element);
            ImagePainter painter = attr.contains("painterName") ? (ImagePainter)ImagePainterStorage.getInstance().get(((XMLAttribute)attr.get("painterName")).getValue()) : ImagePainterStorage.IMAGE_BOUNDS_XY;
            AnimationSprite sprite = new AnimationSprite((float)x, (float)y, width, height, new Animation((TimeCounter)timeCounter, image), painter);
            sprite.setVisible(attr.contains("visible") ? ((XMLAttribute)attr.get("visible")).getBool() : true);
            sprite.setExist(attr.contains("exist") ? ((XMLAttribute)attr.get("exist")).getBool() : true);
            result.add(sprite);
        }
        return result;
    }

    private MapLayerSprite parseMap(XMLElement parent) throws IllegalXMLFormatException, NameNotFoundException, RasterFormatException {
        List<XMLElement> mapElements = parent.getElement("map");
        MapData[] mapData = new CSVMapData[mapElements.size()];
        int[] frame = new int[mapElements.size()];
        int mapElementSize = mapElements.size();
        for (int i = 0; i < mapElementSize; ++i) {
            XMLElement mapElement = mapElements.get(i);
            XMLAttributeStorage mapElementAttr = mapElement.getAttributes();
            String values = mapElement.getValue();
            if (values == null) {
                values = "";
            }
            values = values.replaceAll(" ", "").replaceAll("\t", "").replaceAll("\n", "");
            mapData[i] = new CSVMapData((ChipSet)ChipSetStorage.getInstance().get(((XMLAttribute)mapElementAttr.get("chipSet")).getValue()), values.split(((XMLAttribute)mapElementAttr.get("lineSeparator")).getValue()), this.chipWidth, this.chipHeight);
            frame[i] = mapElementAttr.contains("frame") ? ((XMLAttribute)mapElementAttr.get("frame")).getIntValue() : 0;
        }
        return new MapLayerSprite((float)FieldMapBuilderStorage.getInstance().getX(), (float)FieldMapBuilderStorage.getInstance().getY(), (float)FieldMapBuilderStorage.getInstance().getWidth(), (float)FieldMapBuilderStorage.getInstance().getHeight(), new FrameTimeCounter(frame), mapData);
    }

    private BackgroundLayerSprite parseBackground(List<XMLElement> elements) throws IllegalXMLFormatException, NameNotFoundException, RasterFormatException {
        if (elements.size() > 1) {
            throw new IllegalXMLFormatException("illegal background element size=" + elements.size());
        }
        XMLElement backgroundElement = elements.get(0);
        BufferedImage[] images = this.parseImages(backgroundElement);
        if (images == null) {
            throw new IllegalXMLFormatException("illegal image element : " + backgroundElement);
        }
        XMLAttributeStorage backgroundElementAttr = backgroundElement.getAttributes();
        return new BackgroundLayerSprite(((XMLAttribute)backgroundElementAttr.get("speed")).getFloatValue(), FieldMapBuilderStorage.getInstance().getX(), FieldMapBuilderStorage.getInstance().getY(), FieldMapBuilderStorage.getInstance().getWidth(), FieldMapBuilderStorage.getInstance().getHeight(), this.chipWidth, this.chipHeight, new FrameTimeCounter(StringUtil.parseIntCSV(((XMLAttribute)backgroundElementAttr.get("frame")).getValue())), images);
    }

    private BufferedImage[] parseImages(XMLElement parent) throws RasterFormatException {
        BufferedImage[] images = null;
        if (parent.getElement("spriteSheet") != null) {
            XMLElement spriteSheetElement = parent.getElement("spriteSheet").get(0);
            XMLAttributeStorage spriteSheetAttr = spriteSheetElement.getAttributes();
            int cutX = ((XMLAttribute)spriteSheetAttr.get("x")).getIntValue();
            int cutY = ((XMLAttribute)spriteSheetAttr.get("y")).getIntValue();
            int cutWidth = ((XMLAttribute)spriteSheetAttr.get("width")).getIntValue();
            int cutHeight = ((XMLAttribute)spriteSheetAttr.get("height")).getIntValue();
            SpriteSheet spriteSheet = new SpriteSheet(((XMLAttribute)spriteSheetAttr.get("src")).getValue());
            String cutType = ((XMLAttribute)spriteSheetAttr.get("cutType")).getValue();
            if ("SPLIT".equals(cutType)) {
                spriteSheet.split(cutWidth, cutHeight);
            } else if ("COLUMN".equals(cutType)) {
                spriteSheet.columns(cutX, cutWidth, cutHeight);
            } else {
                spriteSheet.rows(cutY, cutWidth, cutHeight);
            }
            images = spriteSheet.images();
        } else if (parent.getElement("image") != null) {
            List<XMLElement> imageElements = parent.getElement("image");
            images = new BufferedImage[imageElements.size()];
            int imageElementsSize = imageElements.size();
            for (int i = 0; i < imageElementsSize; ++i) {
                XMLElement imageElement = imageElements.get(i);
                BufferedImage image = ImageUtil.load(((XMLAttribute)imageElement.getAttributes().get("src")).getValue());
                if (imageElement.getElement("cutter") != null) {
                    XMLElement cutterElement = imageElement.getElement("cutter").get(0);
                    XMLAttributeStorage cutterAttr = cutterElement.getAttributes();
                    int cutX = ((XMLAttribute)cutterAttr.get("x")).getIntValue();
                    int cutY = ((XMLAttribute)cutterAttr.get("y")).getIntValue();
                    int cutWidth = ((XMLAttribute)cutterAttr.get("width")).getIntValue();
                    int cutHeight = ((XMLAttribute)cutterAttr.get("height")).getIntValue();
                    image = ImageUtil.trimming(image, cutX, cutY, cutWidth, cutHeight);
                }
                images[i] = image;
            }
        }
        return images;
    }

    @Override
    public XMLFieldMapBuilder free() {
        if (this.textStorage != null) {
            this.textStorage.free();
        }
        this.fieldMap = null;
        this.loaded = false;
        GameLog.printInfo("\u30d5\u30a3\u30fc\u30eb\u30c9\u30de\u30c3\u30d7\u30c7\u30fc\u30bf\u3001\u30c6\u30ad\u30b9\u30c8\u30c7\u30fc\u30bf\u304c\u958b\u653e\u3055\u308c\u307e\u3057\u305f XMLFieldMapBuilder.name=[" + this.getName() + "]");
        return this;
    }

    @Override
    public XMLFieldMapBuilder freeSound() {
        this.soundMap.free();
        GameLog.printInfo("\u30b5\u30a6\u30f3\u30c9\u30c7\u30fc\u30bf\u304c\u958b\u653e\u3055\u308c\u307e\u3057\u305f XMLFieldMapBuilder.name=[" + this.getName() + "]");
        return this;
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public SoundMap getSoundMap() {
        return this.soundMap;
    }

    public void setSoundMap(SoundMap soundMap) {
        this.soundMap = soundMap;
    }

    @Override
    public NodeMap getNodeMap() {
        return this.nodeMap;
    }

    public void setNodeMap(NodeMap nodeMap) {
        this.nodeMap = nodeMap;
    }

    public XMLReader getDataFileReader() {
        return this.dataFileReader;
    }

    public void setDataFileReader(XMLReader dataFileReader) {
        this.dataFileReader = dataFileReader;
    }

    @Override
    public int getChipWidth() {
        return this.chipWidth;
    }

    @Override
    public int getChipHeight() {
        return this.chipHeight;
    }

    @Override
    public MessageWindowSprite getMessageWindowSprite() throws IllegalStateException {
        if (!this.loaded) {
            throw new IllegalStateException("MessageWindowSprite\u304c\u8981\u6c42\u3055\u308c\u307e\u3057\u305f\u304c\u3001\u30ed\u30fc\u30c9\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (this.textStorage == null) {
            return null;
        }
        return this.textStorage.getMessageWindowSprite();
    }

    @Override
    public TextStorage getTextStorage() {
        return this.textStorage;
    }

    public String toString() {
        return "FieldMapBuilder{name=" + this.name + ", soundMap=" + this.soundMap + ", nodeMap=" + this.nodeMap.size() + ", dataFileReader=" + this.dataFileReader + ", loaded=" + this.loaded + '}';
    }

    @Override
    public int compareTo(FieldMapBuilder o) {
        return this.name.compareTo(o.getName());
    }
}

