/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.ui;

import java.awt.Graphics2D;
import kinugasa.contents.resource.Nameable;
import kinugasa.object.Model;
import kinugasa.rpgui.FontModel;
import kinugasa.ui.TextLabelModelStorage;
import kinugasa.ui.TextLabelSprite;

public abstract class TextLabelModel
extends Model
implements Nameable {
    private final String name;
    private FontModel font;

    public TextLabelModel(String name, FontModel font) {
        this.name = name;
        this.font = font;
        this.addThis();
    }

    private void addThis() {
        if (!TextLabelModelStorage.getInstance().contains(this.name)) {
            TextLabelModelStorage.getInstance().add(this);
        }
    }

    @Override
    public final String getName() {
        return this.name;
    }

    protected final void setProperty(Graphics2D g) {
        g.setFont(this.font.getFont());
        g.setColor(this.font.getColor());
    }

    public abstract void draw(Graphics2D var1, TextLabelSprite var2);

    public int getFontSize() {
        return this.font.getFont().getSize();
    }

    public FontModel getFontConfig() {
        return this.font;
    }

    @Override
    public TextLabelModel clone() {
        return (TextLabelModel)super.clone();
    }
}

