/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.contents.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import kinugasa.contents.resource.NameNotFoundException;
import kinugasa.contents.resource.NotYetLoadedException;
import kinugasa.game.GameLog;

/**
 * ̃NX̃CxgCxg}l[Wł.
 * <br>
 * ̃NX͕̌^Event̎nɔdg݂񋟂܂B<br>
 * NXCX^XɂāAɔCxgKv邽߁AʏSingleClassEventManagerᑬłB<br>
 * <br>
 * Cxgo^ɂ́ÃNX̋ۃNX`Ainit\bhadd\bhgpăCxgǉ܂B<br>
 * <br>
 * CxgsɂhasNext\bhexecute\bh𗘗p܂B<br>
 * {@code
 * while(manager.hasNext(Item.class)){
 * items.add(manager.execute(Item.class));
 * }
 * }
 * <br>
 *
 * @version 1.0.0 - 2012/11/15_8:42:48<br>
 * @author Dra0211<br>
 * <br>
 *
 */
public abstract class MultiClassEventManager extends EventManager {

	private static final long serialVersionUID = 5774295111597602465L;
	/** ̃}l[W̃CxgXgł. */
	private List<Event<?>> events;

	/**
	 * VCxg}l[W\z܂.
	 * ̃\bhł́ACxg̏l32ƂȂ܂B<br>
	 */
	public MultiClassEventManager() {
		this(32);
	}

	/**
	 * VCxg}l[W\z܂.
	 *
	 * @param initialSize Cxg̏eʂw肵܂B<br>
	 */
	public MultiClassEventManager(int initialSize) {
		events = new ArrayList<Event<?>>(initialSize);
	}

	@Override
	protected abstract void init();

	@Override
	public MultiClassEventManager load() {
		return (MultiClassEventManager) super.load();
	}

	@Override
	public MultiClassEventManager free() {
		return (MultiClassEventManager) super.free();
	}

	@Override
	public void printAll() {
		for (int i = 0, size = events.size(); i < size; i++) {
			GameLog.printInfo("-" + events.get(i));
		}
	}

	@Override
	public void sort() {
		Collections.sort(events);
	}

	@Override
	public int size() {
		return events.size();
	}

	@Override
	public boolean isEmpty() {
		return events.isEmpty();
	}

	@Override
	public void clear() {
		events.clear();
	}

	@Override
	public boolean contains(Event<?> evt) {
		return events.contains(evt);
	}

	@Override
	public void remove(Event<?> evt) {
		events.remove(evt);
	}

	@Override
	public void removeAll(Event<?>... evt) {
		events.removeAll(Arrays.asList(evt));
	}

	/**
	 * ̃}l[WɐVCxgǉ܂.
	 * ǉCxǧ^͔CӂłB<br>
	 * ̃\bh́A}l[W[hς݂łgpł܂B<br>
	 * ̏ꍇ̓Cxg\[g܂B<br>
	 * [hȌꍇ́A[hɃ\[g܂B<br>
	 * \[gꍇsort\bhgpĂB<br>
	 *
	 * @param e ǉCxg𑗐M܂B<br>
	 */
	public final void add(Event<?> e) {
		events.add(e);
	}

	/**
	 * ̃}l[WɐVCxgǉ܂.
	 * ǉCxǧ^͔CӂłB<br>
	 * ̃\bh́A}l[W[hς݂łgpł܂B<br>
	 * ̏ꍇ̓Cxg\[g܂B<br>
	 * [hȌꍇ́A[hɃ\[g܂B<br>
	 * \[gꍇsort\bhgpĂB<br>
	 *
	 * @param e ǉCxg𑗐M܂B<br>
	 */
	public final void addAll(Event<?>... e) {
		events.addAll(Arrays.asList(e));
	}

	/**
	 * w肵^́AŏɌCxgԂ܂.
	 * ̃\bhł͔ꂽCxgs^폜ɕԂ܂B<br>
	 * ʏhasNextexecutegpĂB<br>
	 *
	 * @param <T> Cxǧ^w肵܂B<br>
	 * @param type Cxǧ^w肵܂B<br>
	 *
	 * @return w肵^̃CxgōŏɌ̂̂܂ܕԂ܂B<br>
	 *
	 * @throws NotYetLoadedException }l[W[hĂȂꍇɓ܂B<br>
	 * @throws NameNotFoundException w肳ꂽ^̃Cxg̃}l[WɊ܂܂ĂȂꍇɓ܂B<br>
	 */
	@SuppressWarnings("unchecked")
	public final <T extends Serializable> Event<T> getNext(Class<T> type) throws NotYetLoadedException, NameNotFoundException {
		if (!isLoaded()) {
			throw new NotYetLoadedException("not yet loaded : load=[" + isLoaded() + "]");
		}
		for (int i = 0, size = events.size(); i < size; i++) {
			if (events.get(i).getType().equals(type) || type.isInstance(events.get(i).getObject())) {
				return (Event<T>) events.get(i);
			}
		}
		throw new NameNotFoundException("not found : type=[" + type.getName() + "]");
	}

	/**
	 * w肵^̃CxgAs\ȏԂőҋ@ł邩܂.
	 * ̃\bhł́Ã}l[Wɓo^ĂCxĝAw肵^̍ŏɌCxg
	 * isReachingtrueԂǂ܂B<br>
	 *
	 * @param <T> Cxǧ^w肵܂B<br>
	 * @param type Cxǧ^w肵܂B<br>
	 *
	 * @return w肵^̍ŏɔꂽCxgisReachinǧʂԂ܂B<br>
	 *
	 * @throws NotYetLoadedException }l[W[hĂȂꍇɓ܂B<br>
	 */
	public final <T> boolean hasNext(Class<T> type) throws NotYetLoadedException {
		if (!isLoaded()) {
			throw new NotYetLoadedException("not yet loaded : load=[" + isLoaded() + "]");
		}
		Event<?> evt;
		for (int i = 0, size = events.size(); i < size; i++) {
			evt = events.get(i);
			if (evt.getType().equals(type) || type.isInstance(evt.getObject())) {
				if (evt.isReaching()) {
					return true;
				}
			}
		}
		return false;
	}

	/**
	 * w肵^́AŏɌCxgs\łΎsăCxg̃ACeԂ܂.
	 * ̃\bhŕԂIuWFNǵAꂽCxgexecutěʂłB<br>
	 * ̃\bh́AsłCxg݂ȂꍇnullԂ_ɒӂĂB<br>
	 * ʏ́Aȉ̂悤hasNextgݍ킹Ďgp܂B<br>
	 * <br>
	 * while (eventManager.hasNext(TextLabel.class)) {<br>
	 * labels.add(eventManager.execute(TextLabel.class));<br>
	 * }<br>
	 * <br>
	 *
	 * @param <T> Cxǧ^w肵܂B<br>
	 * @param type Cxǧ^w肵܂B<br>
	 *
	 * @return Cxgsꍇ́ÃCxgexecutěʂԂ܂BsCxgȂꍇnullԂ܂B<br>
	 *
	 * @throws NotYetLoadedException }l[W[hĂȂꍇɓ܂B<br>
	 */
	public final <T extends Serializable> T execute(Class<T> type) throws NotYetLoadedException {
		if (!isLoaded()) {
			throw new NotYetLoadedException("not yet loaded : load=[" + isLoaded() + "]");
		}
		if (!hasNext(type)) {
			return null;
		}
		Event<T> evt = getNext(type);
		GameLog.printIfUsing(Level.INFO, "> MultiClassEventManager : execute : now=[" + getProgressTime() + "] event=[" + evt + "]");
		remove(evt);
		return evt.execute();
	}

	/**
	 * ̃}l[WɊ܂܂Ă邷ׂẴCxg擾܂.
	 * ̃\bh͎QƂێ܂B߂lɑ΂鑀͂̃}l[Wɔf܂B<br>
	 *
	 * @return }l[WɌ݊i[ĂCxg̃XgԂ܂B<br>
	 */
	public List<Event<?>> getEvents() {
		return events;
	}

	@Override
	public String toString() {
		return "> MultiClassEventManager{" + "load=" + isLoaded() + ", events=" + size() + ", progressTime=" + getProgressTime() + '}';
	}
}
