/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.contents.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import kinugasa.contents.resource.NotYetLoadedException;
import kinugasa.game.GameLog;

/**
 * P̃NX̃CxgCxg}l[Wł.
 * <br>
 * ̃NX͒P̌^Event̎nɔdg݂񋟂܂B<br>
 * NXCX^XɂĎɔCxgKvȂ߁AʏMultiClassEventManager
 * ɓ삵܂B<br>
 * <br>
 * <br>
 * Cxgo^ɂ́ÃNX̋ۃNX`Ainit\bhadd\bhgpăCxgǉ܂B<br>
 * <br>
 * CxgsɂhasNext\bhexecute\bh𗘗p܂B<br>  {@code
 * while(manager.hasNext()){
 * items.add(manager.execute());
 * }
 * }
 *
 * @param <T> ̃}l[WCxǧ^w肵܂B<br>
 *
 * @version 1.0.0 - 2012/11/15_8:04:20<br>
 * @author Dra0211<br>
 * <br>
 *
 */
public abstract class SingleClassEventManager<T extends Serializable> extends EventManager {

	private static final long serialVersionUID = 576975168711401996L;
	/**
	 * ̃}l[W̃CxgXgł.
	 */
	private List<Event<T>> events;

	/**
	 * VCxg}l[W\z܂. ̃\bhł́ACxg̏l32ƂȂ܂B<br>
	 */
	public SingleClassEventManager() {
		this(32);
	}

	/**
	 * VCxg}l[W\z܂.
	 *
	 * @param initialSize Cxg̏eʂw肵܂B<br>
	 */
	public SingleClassEventManager(int initialSize) {
		events = new ArrayList<Event<T>>(initialSize);
	}

	@Override
	protected abstract void init();

	@Override
	public SingleClassEventManager<T> load() {
		return (SingleClassEventManager<T>) super.load();
	}

	@Override
	public SingleClassEventManager<T> free() {
		return (SingleClassEventManager<T>) super.free();
	}

	@Override
	public void printAll() {
		for (int i = 0, size = events.size(); i < size; i++) {
			GameLog.printInfo("-" + events.get(i));
		}
	}

	@Override
	public void sort() {
		Collections.sort(events);
	}

	@Override
	public int size() {
		return events.size();
	}

	@Override
	public boolean isEmpty() {
		return events.isEmpty();
	}

	@Override
	public void clear() {
		events.clear();
	}

	@Override
	public boolean contains(Event<?> evt) {
		return events.contains(evt);
	}

	@Override
	public void remove(Event<?> evt) {
		events.remove(evt);
	}

	@Override
	public void removeAll(Event<?>... evt) {
		events.removeAll(Arrays.asList(evt));
	}

	/**
	 * ̃}l[WɐVCxgǉ܂. ̃\bh́A}l[W[hς݂łgpł܂B<br>
	 * ̏ꍇ̓Cxg\[g܂B<br>
	 * [hȌꍇ́A[hɃ\[g܂B<br>
	 * \[gꍇsort\bhgpĂB<br>
	 *
	 * @param evt ǉCxg𑗐M܂B<br>
	 */
	public void add(Event<T> evt) {
		events.add(evt);
	}

	/**
	 * ̃}l[WɐVCxgǉ܂. ̃\bh́A}l[W[hς݂łgpł܂B<br>
	 * ̏ꍇ̓Cxg\[g܂B<br>
	 * [hȌꍇ́A[hɃ\[g܂B<br>
	 * \[gꍇsort\bhgpĂB<br>
	 *
	 * @param evt ǉCxg𑗐M܂B<br>
	 */
	public void addAll(Event<T>... evt) {
		events.addAll(Arrays.asList(evt));
	}

	/**
	 * ̃}l[WɊ܂܂Ă邷ׂẴCxg擾܂.
	 * ̃\bh͎QƂێ܂B߂lɑ΂鑀͂̃}l[Wɔf܂B<br>
	 *
	 * @return }l[WɌ݊i[ĂCxg̃XgԂ܂B<br>
	 */
	public List<Event<T>> getEvents() {
		return events;
	}

	/**
	 * CxgXg̐擪̃CxgԂ܂. ̃\bhł͔ꂽCxgs^폜ɕԂ܂B<br>
	 * ʏhasNextexecutegpĂB<br>
	 *
	 * @return CxgXg̐擪̗vf̂܂ܕԂ܂BisEmptytruȅꍇnullԂ܂B<br>
	 *
	 * @throws NotYetLoadedException }l[W[hĂȂꍇɓ܂B<br>
	 */
	public Event<T> getNext() throws NotYetLoadedException {
		if (!isLoaded()) {
			throw new NotYetLoadedException("not yet loaded : load=[" + isLoaded() + "]");
		}
		if (isEmpty()) {
			return null;
		}
		return events.get(0);
	}

	/**
	 * CxgXg̐擪̃Cxgs\łΎsăCxg̃ACeԂ܂.
	 * ̃\bhŕԂIuWFNǵAꂽCxgexecutěʂłB<br>
	 * ̃\bh́AsłCxg݂ȂꍇnullԂ_ɒӂĂB<br>
	 * ʏ́Aȉ̂悤hasNextgݍ킹Ďgp܂B<br>
	 * <br>
	 *
	 * @return
	 * Cxgsꍇ́ÃCxgexecutěʂԂ܂BsCxgȂꍇ(hasNext==false)nullԂ܂B<br>
	 *
	 * @throws NotYetLoadedException }l[W[hĂȂꍇɓ܂B<br>
	 */
	public T execute() throws NotYetLoadedException {
		if (!isLoaded()) {
			throw new NotYetLoadedException("not yet loaded : load=[" + isLoaded() + "]");
		}
		if (!hasNext()) {
			return null;
		}
		Event<T> evt = events.get(0);
		GameLog.printIfUsing(Level.INFO, "> SingleClassEventManager : execute : now=[" + getProgressTime() + "] event=[" + evt + "]");
		remove(evt);
		return evt.execute();
	}

	/**
	 * CxgXg̐擪̃Cxgs\ȏԂőҋ@ł邩܂.
	 * ̃\bhł́Ã}l[Wɓo^ĂCxgXg̍ŏ̃Cxg
	 * isReachingtrueԂǂ܂B<br>
	 *
	 * @return CxgXg̐擪̃CxgisReachinǧʂԂ܂B<br>
	 *
	 * @throws NotYetLoadedException }l[W[hĂȂꍇɓ܂B<br>
	 */
	public boolean hasNext() throws NotYetLoadedException {
		if (!isLoaded()) {
			throw new NotYetLoadedException("not yet loaded : load=[" + isLoaded() + "]");
		}
		if (isEmpty()) {
			return false;
		}
		return events.get(0).isReaching();
	}

	@Override
	public String toString() {
		return "SingleClassEventManager{" + "load=" + isLoaded() + ", events=" + size() + ", progressTime=" + getProgressTime() + '}';
	}
}
