/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.contents.graphics;

import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import kinugasa.game.GameLog;

/**
 * OtBbNXReLXgɑ΂鑀̃[eBeBł.
 * <br>
 *
 * <br>
 *
 * @version 1.0.0 - 2013/01/12_21:47:44<br>
 * @author Dra0211<br>
 */
public final class GraphicsUtil {

	/**
	 * CX^Xł܂.
	 */
	private GraphicsUtil() {
	}

	/**
	 * Java2DOpenGLpCvCL܂.
	 * ɂẮA`ptH[}Xシꍇ܂B<br>
	 */
	public static void useOpenGL() {
		System.setProperty("sun.java2d.opengl", "true");
		GameLog.printInfoIfUsing( "> opengl state : [" + System.getProperty("sun.java2d.opengl") + "]");
	}

	/**
	 * OpenGLpCvCgpĂ邩܂.
	 *
	 * @return OpenGLpCvCgpĂꍇ́AtrueԂ܂B<br>
	 */
	public static boolean isUseOpenGL() {
		return System.getProperty("sun.java2d.opengl").equals("true");
	}

	/**
	 * Rectangle2DCX^XgpāAclearRects܂.
	 *
	 * @param g ރOtBbNXReLXgw肵܂B<br>
	 * @param r `͈͂ƂȂRectangle2DCX^Xw肵܂B<br>
	 */
	public static void clearRect(Graphics g, Rectangle2D r) {
		g.clearRect((int) r.getX(), (int) r.getY(), (int) r.getWidth(), (int) r.getHeight());
	}

	/**
	 * Rectangle2DCX^XgpāAdrawRects܂.
	 *
	 * @param g ރOtBbNXReLXgw肵܂B<br>
	 * @param r `͈͂ƂȂRectangle2DCX^Xw肵܂B<br>
	 */
	public static void drawRect(Graphics g, Rectangle2D r) {
		g.drawRect((int) r.getX(), (int) r.getY(), (int) r.getWidth(), (int) r.getHeight());
	}

	/**
	 * Rectangle2DCX^XgpāAfillRects܂.
	 *
	 * @param g ރOtBbNXReLXgw肵܂B<br>
	 * @param r `͈͂ƂȂRectangle2DCX^Xw肵܂B<br>
	 */
	public static void fillRect(Graphics g, Rectangle2D r) {
		g.fillRect((int) r.getX(), (int) r.getY(), (int) r.getWidth(), (int) r.getHeight());
	}

	/**
	 * Rectangle2DCX^XgpāAdrawOvals܂.
	 *
	 * @param g ރOtBbNXReLXgw肵܂B<br>
	 * @param r `͈͂ƂȂRectangle2DCX^Xw肵܂B<br>
	 */
	public static void drawOval(Graphics g, Rectangle2D r) {
		g.drawOval((int) r.getX(), (int) r.getY(), (int) r.getWidth(), (int) r.getHeight());
	}

	/**
	 * Rectangle2DCX^XgpāAfillOvals܂.
	 *
	 * @param g ރOtBbNXReLXgw肵܂B<br>
	 * @param r `͈͂ƂȂRectangle2DCX^Xw肵܂B<br>
	 */
	public static void fillOval(Graphics g, Rectangle2D r) {
		g.fillOval((int) r.getX(), (int) r.getY(), (int) r.getWidth(), (int) r.getHeight());
	}
}
