/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.contents.resource;

import kinugasa.util.ArrayUtil;

/**
 * vf̃[h^J@\ǉXg[W̎ł.
 * <br>
 * ̃Xg[W̊ǵAFreeable܂BFreeable̋@\́ASĂ̗vfɓKp܂B
 * isLoaded1ȏ̗vf[hĂꍇtrueԂ܂BSĂ̗vf[hĂ邩ɂ
 * isLoadedAllgp܂B<br>
 * <br>
 *
 * @param <T> ̃Xg[Wۑ閽\ŊJ\Ȍ^w肵܂B<br>
 *
 * @version 1.0.0 - 2012/11/18_0:14:31<br>
 * @version 1.0.2 - 2013/01/12_22:16:16<br>
 * @version 1.1.0 - 2013/02/19_00:49<br>
 * @version 1.1.2 - 2013/04/13_19:31<br>
 * @version 1.4.0 - 2013/04/28_23:40<br>
 * @author Dra0211<br>
 */
public abstract class DynamicStorage<T extends Nameable & Freeable & Loadable>
		extends Storage<T> implements Freeable, Loadable {

	/**
	 * VXg[W쐬܂.
	 *
	 * @param initialSize Xg[W̏eʂw肵܂B<br>
	 */
	public DynamicStorage(int initialSize) {
		super(initialSize);
	}

	/**
	 * VXg[W쐬܂.
	 */
	public DynamicStorage() {
	}

	/**
	 * SĂ̗vf[h܂.
	 *
	 * @return ̃Xg[WԂ܂B<br>
	 */
	@Override
	public DynamicStorage<T> load() {
		for (T obj : this) {
			obj.load();
		}
		return this;
	}

	/**
	 * w肵OIuWFNgA[hĂ擾܂.
	 *
	 * @param name IuWFNg̖Ow肵܂B<br>
	 * @return [hꂽIuWFNgԂ܂B<br>
	 * @throws NameNotFoundException w肵OIuWFNg̃Xg[WɊ܂܂ĂȂ
	 * ɓ܂B<br>
	 */
	public T load(String name) throws NameNotFoundException {
		T obj = get(name);
		obj.load();
		return obj;
	}

	/**
	 * SĂ̗vfJ܂.
	 *
	 * @return ̃Xg[WԂ܂B<br>
	 */
	@Override
	public DynamicStorage<T> free() {
		for (T obj : this) {
			obj.free();
		}
		return this;
	}

	/**
	 * w肵OIuWFNgAJ擾܂.
	 *
	 * @param name IuWFNg̖Ow肵܂B<br>
	 * @return JꂽIuWFNgԂ܂B<br>
	 * @throws NameNotFoundException w肵OIuWFNg̃Xg[WɊ܂܂ĂȂ
	 * ɓ܂B<br>
	 */
	public T free(String name) throws NameNotFoundException {
		T obj = get(name);
		obj.free();
		return obj;
	}

	/**
	 * w肳ꂽSĂ̗vf[h܂.
	 *
	 * @param names [hvf̖Ow肵܂B<br>
	 */
	public void loadAll(String... names) {
		for (T obj : this) {
			if (ArrayUtil.contains(names, obj.getName())) {
				obj.load();
			}
		}
	}

	/**
	 * w肳ꂽSĂ̗vfJ܂.
	 *
	 * @param names Jvf̖Ow肵܂B<br>
	 */
	public void freeAll(String... names) {
		for (T obj : this) {
			if (ArrayUtil.contains(names, obj.getName())) {
				obj.free();
			}
		}
	}

	/**
	 * w肳ꂽOIuWFNgȊOSĊJ܂.
	 *
	 * @param names JȂIuWFNg̖O𑗐M܂B<br>
	 */
	public void exFree(String... names) {
		for (T obj : this) {
			if (!ArrayUtil.contains(names, obj.getName())) {
				obj.free();
			}
		}
	}

	/**
	 * Œ1̗vf[hĂ邩܂.
	 *
	 * @return 1ȏ̗vf[hĂꍇtrueASĂ̗vf[hĂȂꍇ falseԂ܂B<br>
	 */
	@Override
	public boolean isLoaded() {
		for (T obj : this) {
			if (obj.isLoaded()) {
				return true;
			}
		}
		return false;
	}

	/**
	 * SĂ̗vf[hĂ邩܂.
	 *
	 * @return SĂ̗vf[hĂꍇtrueԂ܂B<br>
	 */
	public boolean isLoadedAll() {
		for (T obj : this) {
			if (!obj.isLoaded()) {
				return false;
			}
		}
		return true;
	}

	/**
	 * w肵OIuWFNgA[hĂ邩𒲂ׂ܂.
	 *
	 * @param name IuWFNg̖Ow肵܂B<br>
	 * @return w肵OIuWFNgisLoadedԂ܂B<br>
	 * @throws NameNotFoundException w肵OIuWFNg̃Xg[WɊ܂܂ĂȂ
	 * ɓ܂B<br>
	 */
	public boolean isLoaded(String name) throws NameNotFoundException {
		return get(name).isLoaded();
	}
}
