/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.contents.saveData;

import java.io.Serializable;
import kinugasa.contents.resource.Storage;
import kinugasa.inputDevice.InputState;
import kinugasa.util.Random;

/**
 * ̃NXgpāA_V[hƓ͏Ԃ𔭍s^邱Ƃo܂.
 * <br>
 * vC̃f[^ʂ͓͂̑ɔႵđȂ܂B<br>
 * <br>
 *
 * @version 1.0.0 - 2013/01/20_18:24:22<br>
 * @author Dra0211<br>
 */
public final class ReplayData extends Storage<ReplayInputState> implements Serializable {

	private static final long serialVersionUID = -7860006069807950463L;
	/** gpĂV[hł. */
	private long seed;

	/**
	 * VvC쐬܂.
	 * FPS60AԂ5ɂȂ܂B<br>
	 */
	public ReplayData() {
		this(60, 5);
	}

	/**
	 * VvC쐬܂.
	 *
	 * @param fps    s̃Q[̍őFSPw肵܂Bf[^ʂɉe܂B<br>
	 * @param minute Q[̎sԂw肵܂Bf[^ʂɉe܂B<br>
	 */
	public ReplayData(int fps, float minute) {
		super((int) (fps * minute));
	}

	/**
	 * V[hAvC̕ۑJn܂.
	 *
	 * @param seed V[hw肵܂Bkinugasa RandomNX̃V[h܂B<br>
	 *
	 * @return thisCX^XԂ܂B<br>
	 */
	public ReplayData recStart(long seed) {
		Random.initSeed(this.seed = seed);
		return this;
	}

	/**
	 * KȃV[hgpăvC̕ۑJn܂.
	 *
	 * @return thisCX^XԂ܂B<br>
	 */
	public ReplayData recStart() {
		return recStart(System.nanoTime());
	}

	/**
	 * ۑꂽV[hgpāA_NXAvC̍ĐJn܂.
	 */
	public void playStart() {
		Random.initSeed(seed);
	}

	/**
	 * t[Ɠ͏Ԃw肵āA̓Cxgo^܂.
	 * ̃\bhadd(new ReplayInputState(frame, inputState))Ɠ܂B<br>
	 *
	 * @param frame      ͂mꂽt[w肵܂BGameTimeManager擾ł܂B<br>
	 * @param inputState ͏Ԃ𑗐M܂BReplayInputStateŃN[jO܂B<br>
	 */
	public void add(long frame, InputState inputState) {
		super.add(new ReplayInputState(frame, inputState));
	}

	/**
	 * ݂̃t[œ͂ꂽԂ𕜌܂.
	 *
	 * @param frame ͂st[w肵܂BGameTimeManager擾ł܂B<br>
	 *
	 * @return w肳ꂽt[̓͏ԂԂ܂B̃t[ɓ͂ꍇnullԂ܂B<br>
	 */
	public InputState get(long frame) {
		ReplayInputState state = super.getIfContains(Long.toString(frame));
		return state == null ? null : state.getInputState();
	}
}
