/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.contents.saveData;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kinugasa.contents.resource.ContentsFileNotFoundException;
import kinugasa.contents.resource.ContentsIOException;
import kinugasa.contents.resource.Nameable;

/**
 * Q[̓ro߂ۑ邽߂̃NXł.
 * <br>
 * ̃NXgāAKvȃtB[h`ĂB<br>
 * <br>
 * Z[uf[^̎^ƂẮAOA쐬AXV܂B<br>
 * OƍXV͎RɎgp邱Ƃł܂BONameablẽL[Ƃ
 * gp܂BOƍ쐬́AύXł܂B<br>
 *
 * @version 1.0.0 - 2013/01/13_0:10:27<br>
 * @author Dra0211<br>
 */
public abstract class SaveData implements Nameable, Serializable {

	private static final long serialVersionUID = 5051478173983169607L;
	/** Z[uf[^̖Oł. */
	private String name;
	/** Z[uf[^쐬ꂽł. */
	private long createTime;
	/** ŏIXVȂǂۊǂDateł. */
	private Date date;

	/**
	 * VZ[uf[^쐬܂.
	 * ̃RXgN^ł́AO͋̕ɐݒ肳܂B<br>
	 */
	public SaveData() {
		this("");
	}

	/**
	 * VZ[uf[^쐬܂.
	 * 쐬эXV݂͌̎ɐݒ肳܂B<br>
	 *
	 * @param name Z[uf[^̖Ow肵܂BӓIłKv܂B<br>
	 */
	public SaveData(String name) {
		this.name = name;
		createTime = System.currentTimeMillis();
		date = new Date();
	}

	@Override
	public final String getName() {
		return name;
	}

	/**
	 * ̃Z[uf[^̍XV擾܂.
	 *
	 * @return ̃Z[uf[^ɐݒ肳ꂽXVԂ܂B<br>
	 */
	public final Date getDate() {
		return date;
	}

	/**
	 * ̃Z[uf[^̍XVݒ肵܂.
	 *
	 * @param date ̃Z[uf[^ɐݒ肷XV𑗐M܂B<br>
	 */
	public final void setDate(Date date) {
		this.date = date;
	}

	/**
	 * ̃Z[uf[^ŏɍ쐬ꂽ擾܂.
	 * ̒ĺAʏ͈ӓIłBA̒l̓~bPʂȂ̂ŁA
	 * ZԂɕ̃Z[uf[^𐶐ꍇ́Ad\܂B<br>
	 *
	 * @return ̃Z[uf[^쐬ꂽԂ܂B<br>
	 */
	public final long getCreateTime() {
		return createTime;
	}

	/**
	 * w肳ꂽt@CɁÃZ[uf[^ۑ܂.
	 * ۑt@CContentsIOgpĕł܂B<Br>
	 *
	 * @param file st@Cw肵܂B㏑̊mF͍s܂B<br>
	 *
	 * @throws ContentsFileNotFoundException t@CpXsȏꍇɓ܂B<br>
	 * @throws ContentsIOException RecIOɎsꍇɓ܂B<br>
	 */
	public final void save(File file) throws ContentsFileNotFoundException, ContentsIOException {
		ContentsIO.save(this, file);
	}

	/**
	 * w肳ꂽt@CAZ[uf[^ǂݍ݂܂.
	 * ̃\bh́AContentsIOgp[hƓ܂B<br>
	 *
	 * @param file ǂݍރt@Cw肵܂B<br>
	 *
	 * @return w肳ꂽt@C畜ꂽZ[uf[^Ԃ܂B<br>
	 *
	 * @throws ContentsFileNotFoundException t@CpXsȏꍇɓ܂B<br>
	 * @throws ContentsIOException RecIOɎsꍇɓ܂B<br>
	 */
	public static SaveData load(File file) throws ContentsFileNotFoundException, ContentsIOException {
		return ContentsIO.load(SaveData.class, file);
	}

	/**
	 * w肳ꂽpXɂ邷ׂĂ̓ǂݍ݉\ȃt@CZ[uf[^Ƃă[hAXgƂĕԂ܂.
	 *
	 * @param dir ǂݍރfBNg̃[gƂȂfBNg̃pXw肵܂BqɂȂfBNg
	 * ċAIɏ܂B<br>
	 *
	 * @return w肳ꂽfBNgȉɂAZ[uf[^̔sς݃f[^𕜌AXgƂĕԂ܂B<br>
	 *
	 * @throws ContentsFileNotFoundException t@CpXsȏꍇɓ܂B<br>
	 * @throws ContentsIOException RecIOɎsꍇɓ܂B<br>
	 * @throws IllegalArgumentException dirfBNgłȂꍇɓ܂B<br>
	 */
	public static List<SaveData> loadAll(File dir) throws ContentsFileNotFoundException, ContentsIOException, IllegalArgumentException {
		if (!dir.isDirectory()) {
			throw new IllegalArgumentException("dir is not directory");
		}
		File[] files = dir.listFiles();
		List<SaveData> result = new ArrayList<SaveData>(files.length);
		for (File file : files) {
			if (file.isDirectory()) {
				result.addAll(loadAll(file));
			} else {
				try {
					result.add(ContentsIO.load(SaveData.class, file));
				} catch (ContentsFileNotFoundException ex) {
					continue;
				} catch (ContentsIOException ex) {
					continue;
				}
			}
		}
		return result;
	}

	@Override
	public String toString() {
		return "SaveData{" + "name=" + name + ", createTime=" + createTime + ", date=" + date + '}';
	}
}
