/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.contents.saveData;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Date;

/**
 * _ł.
 * <br>
 * _́utvAu擾ҁvсu_v܂B<br>
 * tю擾҂́AgpȂꍇnullݒł܂B<br>
 * 擾҂͈ӓIȖOł͂܂B<br>
 * <br>
 * @version 1.0.0 - 2013/05/02_22:06:52<br>
 * @author Dra0211<br>
 */
public class Score implements Serializable, Comparable<Score> {

	private static final long serialVersionUID = -418021841977590513L;
	private String name;
	private Date date;
	private BigInteger score;

	public Score(BigInteger score) {
		this.score = score;
	}

	public Score(Date date, BigInteger score) {
		this.date = date;
		this.score = score;
	}

	public Score(String name, BigInteger score) {
		this.name = name;
		this.score = score;
	}

	public Score(String name, Date date, BigInteger score) {
		this.name = name;
		this.date = date;
		this.score = score;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Date getDate() {
		return date;
	}

	public void setDate(Date date) {
		this.date = date;
	}

	public BigInteger getScore() {
		return score;
	}

	public void setScore(BigInteger score) {
		this.score = score;
	}

	@Override
	public int compareTo(Score t) {
		return t.score.compareTo(this.score);
	}

	@Override
	public String toString() {
		return "Score{" + "name=" + name + ", date=" + date + ", score=" + score + '}';
	}
}
