/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.contents.saveData;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * "_"ۑZ[uf[^ł.
 * <br>
 *
 * <br>
 * @version 1.0.0 - 2013/05/02_22:03:22<br>
 * @author Dra0211<br>
 */
public class ScoreSaveData extends SaveData {

	private static final long serialVersionUID = -5528371805145237488L;
	private List<Score> scoreList;

	public ScoreSaveData(String name) {
		this(name, new ArrayList<Score>());
	}

	public ScoreSaveData(String name, List<Score> scoreList) {
		super(name);
		this.scoreList = scoreList;
	}

	public List<Score> getScoreList() {
		return scoreList;
	}

	public List<Score> getSortedList() {
		List<Score> result = new ArrayList<Score>(scoreList);
		Collections.sort(result);
		return result;
	}

	@Override
	public String toString() {
		return "ScoreSaveData{" + "scoreList=" + scoreList + '}';
	}
}
