/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.contents.sound;

import java.io.File;
import java.io.Serializable;
import kinugasa.contents.resource.ContentsFileNotFoundException;
import kinugasa.contents.resource.Nameable;

/**
 * LbVTEh̃CX^X쐬邽߂̃r_ł.
 * <br>
 * WAVEt@Cgpۂ́AłʓIȍ\zNXƂȂ܂B<br>
 * <br>
 *
 * @version 1.0.0 - 2013/01/13_18:48:59<br>
 * @author Dra0211<br>
 */
public final class SoundBuilder implements Serializable, Nameable {

	private static final long serialVersionUID = -632193381308545739L;
	/** t@CCX^X. */
	private File file;
	/** [vݒ. */
	private LoopPoint loopPoint = LoopPoint.NO_USE;
	/** o[uݒ. */
	private ReverbModel reverbModel = ReverbModel.NO_USE;
	/** }X^[QC̒l. */
	private float masterGain = 1f;
	/** {[. */
	private float volume = 1f;
	/** p̐ݒ. */
	private float pan = 0f;
	/** Đ̃Tv[g. */
	private float sampleRate = 0f;
	/** VKCX^Xō쐬邩. */
	private boolean newFile = false;
	private String name;

	/**
	 * VCachedSound쐬邽߂̃r_\z܂.
	 * 
	 * @param filePath t@CpX.<br>
	 *
	 * @throws ContentsFileNotFoundException t@C݂Ȃꍇɓ.<br>
	 */
	public SoundBuilder(String filePath) throws ContentsFileNotFoundException {
		File soundFile = new File(filePath);
		if (!soundFile.exists()) {
			throw new ContentsFileNotFoundException("not found : filePath=[" + filePath + "]");
		}
		this.file = soundFile;
		this.name = file.getName();
	}

	/**
	 * [vʒuݒ肵܂.
	 * 
	 * @param loopPoint [vʒu.<br>
	 *
	 * @return ̃r_̃CX^X.<br>
	 */
	public SoundBuilder setLoopPoint(LoopPoint loopPoint) {
		this.loopPoint = loopPoint;
		return this;
	}

	/**
	 * [vʒuݒ肵܂.
	 * 
	 * @param from [vʒu.<br>
	 * @param to   [vʒu.<br>
	 *
	 * @return ̃r_̃CX^X.<br>
	 */
	public SoundBuilder setLoopPoint(int from, int to) {
		this.loopPoint = new LoopPoint(from, to);
		return this;
	}

	/**
	 * TEh̃}X^[QCݒ肵܂.
	 * ̓{[T|[gĂȂŉʂݒ肷邱Ƃł܂.<br>
	 * 
	 * @param masterGain QC̒l.0.0fŖɂȂ.<br>
	 *
	 * @return ̃r_̃CX^X.<br>
	 */
	public SoundBuilder setMasterGain(float masterGain) {
		this.masterGain = masterGain;
		return this;
	}

	/**
	 * XeITEh̃pʒuݒ肵܂.
	 * ̋@\̓T|[gĂȂ\܂.
	 * 
	 * @param pan S0.0AE1.0Ƃꍇ̃pʒu.<br>
	 *
	 * @return ̃r_̃CX^X.<br>
	 */
	public SoundBuilder setPan(float pan) {
		this.pan = pan;
		return this;
	}

	/**
	 * TEh̉ʂݒ肵܂.
	 * ̋@\̓T|[gĂȂ\܂.ʂ̒߂̓}X^[QCgpĂ.<br>
	 * 
	 * @param volume .<br>
	 *
	 * @return ̃r_̃CX^X.<br>
	 */
	public SoundBuilder setVolume(float volume) {
		this.volume = volume;
		return this;
	}

	/**
	 * TEh̃o[uݒ肵܂.
	 * ̋@\̓T|[gĂȂ\܂.
	 * 
	 * @param reverbModel o[u̐ݒ.<br>
	 *
	 * @return ̃r_̃CX^X.<br>
	 */
	public SoundBuilder setReverbModel(ReverbModel reverbModel) {
		this.reverbModel = reverbModel;
		return this;
	}

	/**
	 * TEh̍Đ̃Tv[gݒ肵܂.
	 * ̋@\̓T|[gĂȂ\܂.
	 * 
	 * @param sampleRate Đ̃Tv[g.<br>
	 *
	 * @return ̃r_̃CX^X.<br>
	 */
	public SoundBuilder setSampleRate(float sampleRate) {
		this.sampleRate = sampleRate;
		return this;
	}

	/**
	 * ̃\bhĂяoCachedSound̃LbVf[^gpA
	 * VTEhCX^X쐬܂.<br>
	 * 
	 * @return ̃r_̃CX^X.<br>
	 */
	public SoundBuilder newFile() {
		newFile = true;
		return this;
	}

	public SoundBuilder setName(String name) {
		this.name = name;
		return this;
	}

	/**
	 * 쐬\̃TEh̃t@C擾܂.
	 * ̃\bh̖߂l̃t@C݂͑ۏ؂܂.<br>
	 * 
	 * @return t@CCX^X.<br>
	 */
	public File getFile() {
		return file;
	}

	/**
	 * ݒ肳ĂlԂ܂.
	 * 
	 * @return [vʒu.<br>
	 */
	public LoopPoint getLoopPoint() {
		return loopPoint;
	}

	/**
	 * ݒ肳ĂlԂ܂.
	 * 
	 * @return QC̒l.<br>
	 */
	public float getMasterGain() {
		return masterGain;
	}

	/**
	 * ݒ肳ĂlԂ܂.
	 * 
	 * @return LbVgpɐVCX^X쐬ꍇTRUEԂ.<br>
	 */
	public boolean isNewFile() {
		return newFile;
	}

	/**
	 * ݒ肳ĂlԂ܂.
	 * 
	 * @return p̐ݒ.<br>
	 */
	public float getPan() {
		return pan;
	}

	/**
	 * ݒ肳ĂlԂ܂.
	 * 
	 * @return o[u̐ݒ.<br>
	 */
	public ReverbModel getReverbModel() {
		return reverbModel;
	}

	/**
	 * ݒ肳ĂlԂ܂.
	 * 
	 * @return Đ̃Tv[g.<br>
	 */
	public float getSampleRate() {
		return sampleRate;
	}

	/**
	 * ݒ肳ĂlԂ܂.
	 * 
	 * @return .<br>
	 */
	public float getVolume() {
		return volume;
	}

	/**
	 * ݂̐ݒŐVCachedSound쐬܂.
	 * 
	 * @return AudioData̎Ԃ.<br>
	 */
	public CachedSound builde() {
		return CachedSound.create(this);
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		final SoundBuilder other = (SoundBuilder) obj;
		if (this.file != other.file && (this.file == null || !this.file.equals(other.file))) {
			return false;
		}
		if (this.loopPoint != other.loopPoint && (this.loopPoint == null || !this.loopPoint.equals(other.loopPoint))) {
			return false;
		}
		if (this.reverbModel != other.reverbModel && (this.reverbModel == null || !this.reverbModel.equals(other.reverbModel))) {
			return false;
		}
		if (Float.floatToIntBits(this.masterGain) != Float.floatToIntBits(other.masterGain)) {
			return false;
		}
		if (Float.floatToIntBits(this.volume) != Float.floatToIntBits(other.volume)) {
			return false;
		}
		if (Float.floatToIntBits(this.pan) != Float.floatToIntBits(other.pan)) {
			return false;
		}
		if (Float.floatToIntBits(this.sampleRate) != Float.floatToIntBits(other.sampleRate)) {
			return false;
		}
		if (this.newFile != other.newFile) {
			return false;
		}
		return true;
	}

	@Override
	public int hashCode() {
		int hash = 7;
		hash = 97 * hash + (this.file != null ? this.file.hashCode() : 0);
		hash = 97 * hash + (this.loopPoint != null ? this.loopPoint.hashCode() : 0);
		hash = 97 * hash + (this.reverbModel != null ? this.reverbModel.hashCode() : 0);
		hash = 97 * hash + Float.floatToIntBits(this.masterGain);
		hash = 97 * hash + Float.floatToIntBits(this.volume);
		hash = 97 * hash + Float.floatToIntBits(this.pan);
		hash = 97 * hash + Float.floatToIntBits(this.sampleRate);
		hash = 97 * hash + (this.newFile ? 1 : 0);
		return hash;
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public String toString() {
		return "SoundBuilder{" + "file=" + file + ", loopPoint=" + loopPoint + ", reverbModel=" + reverbModel + ", masterGain=" + masterGain + ", volume=" + volume + ", pan=" + pan + ", sampleRate=" + sampleRate + ", newFile=" + newFile + '}';
	}
}
