/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.contents.text;

import java.io.Serializable;
import kinugasa.contents.resource.Nameable;

/**
 * L[ɑ΂Ēlێ邽߂̍\̂ł.
 * <br>
 * ̃NX́AINIt@C̃f[^ƂĎgp܂B<br>
 * L[ђlStringƂĊi[Aꂼꂪʂ̃CX^X̑ΉtB[hƓł
 * ꍇiequalstrueԂꍇ)̃vpeB͓Ƃ݂Ȃ܂B<br>
 * <br>
 * Nameable̎ƂẮAL[Ԃ܂B<br>
 *
 * @version 1.0.0<br>
 * @author Dra0211<br>
 */
public class Property implements Serializable, Nameable {

	private static final long serialVersionUID = -5027244314883426876L;
	/** L[. */
	private String key;
	/** l. */
	private String value;

	/**
	 * VvpeB\z܂.
	 * <br>
	 *
	 * @param key   L[.<br>
	 * @param value l.<br>
	 */
	public Property(String key, String value) {
		this.key = key;
		this.value = value;
	}

	/**
	 * L[擾܂.
	 * <br>
	 *
	 * @return L[w肵܂B<br>
	 */
	public String getKey() {
		return key;
	}

	/**
	 * l擾܂.
	 * <br>
	 *
	 * @return lw肵܂B<br>
	 */
	public String getValue() {
		return value;
	}

	/**
	 * L[ݒ肵܂.
	 *
	 * @param key VL[w肵܂B<br>
	 */
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * lݒ肵܂.
	 *
	 * @param value Vlw肵܂B<br>
	 */
	public void setValue(String value) {
		this.value = value;
	}

	/**
	 * L[ђl[ley=value]̌`ŕԂ܂.
	 * <br>
	 *
	 * @return L[ƒl̃yAԂ܂B<bR>
	 */
	@Override
	public String toString() {
		return key + "=" + value;
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		final Property other = (Property) obj;
		if ((this.key == null) ? (other.key != null) : !this.key.equals(other.key)) {
			return false;
		}
		if ((this.value == null) ? (other.value != null) : !this.value.equals(other.value)) {
			return false;
		}
		return true;
	}

	@Override
	public int hashCode() {
		int hash = 7;
		hash = 29 * hash + (this.key != null ? this.key.hashCode() : 0);
		hash = 29 * hash + (this.value != null ? this.value.hashCode() : 0);
		return hash;
	}

	@Override
	public String getName() {
		return key;
	}
}
