/*
 * The MIT License
 *
 * Copyright 2015 Dra.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.contents.text;

import java.io.File;
import java.util.Collection;
import kinugasa.contents.resource.ContentsFileNotFoundException;
import kinugasa.contents.resource.IllegalFormatException;

/**
 * eLXgt@Cp̃[_ł.
 * <br>
 *
 * @version 1.0.0 - 2015/01/04<br>
 * @author Dra<br>
 * <br>
 */
public class SimpleTextReader extends TextReader<String> {

	/**
	 * eLXgt@Cp̓ǂݍ݃p[Tł.
	 */
	private static final Reader<String> TEXT_READER = new Reader<String>() {

		@Override
		public String parse(String line) throws IllegalFormatException {
			return line;
		}
	};

	/**
	 * t@Cw肵āAǂݍݗp̃eLXgt@C쐬܂.
	 *
	 * @param file t@Cw肵܂B<br>
	 *
	 * @throws ContentsFileNotFoundException w肳ꂽt@C݂Ȃꍇɓ܂B<br>
	 */
	public SimpleTextReader(File file) throws ContentsFileNotFoundException {
		super(file, TEXT_READER);
	}

	/**
	 * t@CpXw肵āAǂݍݗp̃eLXgt@C쐬܂.
	 *
	 * @param filePath t@CpXw肵܂B<br>
	 *
	 * @throws ContentsFileNotFoundException w肳ꂽt@C݂Ȃꍇɓ܂B<br>
	 */
	public SimpleTextReader(String filePath) throws ContentsFileNotFoundException {
		super(filePath, TEXT_READER);
	}

	@Override
	public SimpleTextReader load() throws IllegalFormatException {
		return (SimpleTextReader) super.load();
	}

	@Override
	public SimpleTextReader free() {
		return (SimpleTextReader) super.free();
	}

	@Override
	public SimpleTextReader add(Collection<? extends String> obj) {
		return (SimpleTextReader) super.add(obj);
	}

	@Override
	public SimpleTextReader add(String obj) {
		return (SimpleTextReader) super.add(obj);
	}

	@Override
	public SimpleTextReader add(String... obj) {
		return (SimpleTextReader) super.add(obj);
	}

	@Override
	public SimpleTextReader add(TextIO<? extends String> other) {
		return (SimpleTextReader) super.add(other);
	}

	@Override
	public SimpleTextReader remove(Collection<? extends String> obj) {
		return (SimpleTextReader) super.remove(obj);
	}

	@Override
	public SimpleTextReader remove(String obj) {
		return (SimpleTextReader) super.remove(obj);
	}

	@Override
	public SimpleTextReader remove(String... obj) {
		return (SimpleTextReader) super.remove(obj);
	}

	@Override
	public SimpleTextReader remove(TextIO<? extends String> other) {
		return (SimpleTextReader) super.remove(other);
	}

	@Override
	public SimpleTextReader clear() {
		return (SimpleTextReader) super.clear();
	}
}
