/*
 * The MIT License
 *
 * Copyright 2015 Dra.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.contents.text;

import java.io.File;
import java.util.Collection;

/**
 * eLXgt@Cp̃C^ł.
 * <br>
 *
 * @version 1.0.0 - 2015/01/04<br>
 * @author Dra<br>
 * <br>
 */
public class SimpleTextWriter extends TextWriter<String> {

	/**
	 * eLXgt@Cp̏݃p[Tł.
	 */
	private static final Writer<String> TEXT_WRITER = new Writer<String>() {

		@Override
		public String toString(String obj) {
			return obj;
		}
	};

	/**
	 * t@Cw肵āAݗp̃eLXgt@C쐬܂.
	 *
	 * @param file t@Cw肵܂B<br>
	 */
	public SimpleTextWriter(File file) {
		super(file, TEXT_WRITER);
	}

	/**
	 * t@CpXw肵āAݗp̃eLXgt@C쐬܂.
	 *
	 * @param filePath t@CpXw肵܂B<br>
	 */
	public SimpleTextWriter(String filePath) {
		super(filePath, TEXT_WRITER);
	}

	@Override
	public SimpleTextWriter add(Collection<? extends String> obj) {
		return (SimpleTextWriter) super.add(obj);
	}

	@Override
	public SimpleTextWriter add(String obj) {
		return (SimpleTextWriter) super.add(obj);
	}

	@Override
	public SimpleTextWriter add(String... obj) {
		return (SimpleTextWriter) super.add(obj);
	}

	@Override
	public SimpleTextWriter add(TextIO<? extends String> other) {
		return (SimpleTextWriter) super.add(other);
	}

	@Override
	public SimpleTextWriter remove(Collection<? extends String> obj) {
		return (SimpleTextWriter) super.remove(obj);
	}

	@Override
	public SimpleTextWriter remove(String obj) {
		return (SimpleTextWriter) super.remove(obj);
	}

	@Override
	public SimpleTextWriter remove(String... obj) {
		return (SimpleTextWriter) super.remove(obj);
	}

	@Override
	public SimpleTextWriter remove(TextIO<? extends String> other) {
		return (SimpleTextWriter) super.remove(other);
	}

	@Override
	public SimpleTextWriter clear() {
		return (SimpleTextWriter) super.clear();
	}
}
