/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.contents.text;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Collection;
import kinugasa.contents.resource.ContentsFileNotFoundException;
import kinugasa.contents.resource.Freeable;
import kinugasa.contents.resource.ContentsIOException;
import kinugasa.contents.resource.IllegalFormatException;
import kinugasa.contents.resource.Loadable;
import kinugasa.game.GameLog;

/**
 * eLXgt@Cǂލނ߂TextIO̎ł.
 * <br>
 * t@Cǂݍލۂɂ́AǂݍݑΏۂƂȂt@C݂ĂȂ΂ȂȂ̂ŁA RXgN^ł̓t@C̗LmF܂B<br>
 * <br>
 *
 * @param <T> eLXgt@Ĉ1s̓e\NXw肵܂B Ƃ΁ACSVt@CłString[]łB<br>
 *
 * @version 1.0.0 - 2013/01/13_20:02:58<br>
 * @author Dra0211<br>
 */
public abstract class TextReader<T> extends TextIO<T> implements Freeable, Loadable {

	private static final long serialVersionUID = 8671421693215761665L;
	/**
	 * ̃eLXgt@Cǂݍނ߂̃[_ł.
	 */
	private Reader<T> reader;

	/**
	 * t@CpXƃ[_w肵āAǂݍݗpt@C\z܂.
	 *
	 * @param filePath t@CpXw肵܂B<br>
	 * @param parser ͂郊[_w肵܂B<br>
	 *
	 * @throws ContentsFileNotFoundException w肳ꂽt@C݂Ȃꍇɓ܂B<br>
	 */
	public TextReader(String filePath, Reader<T> parser) throws ContentsFileNotFoundException {
		super(filePath);
		if (!file.exists()) {
			throw new ContentsFileNotFoundException("file not found : file=[" + getName() + "]");
		}
		this.reader = parser;
	}

	/**
	 * t@Cƃ[_w肵āAǂݍݗpt@C\z܂.
	 *
	 * @param file t@Cw肵܂B<br>
	 * @param parser ͂郊[_w肵܂B<br>
	 *
	 * @throws ContentsFileNotFoundException w肳ꂽt@C݂Ȃꍇɓ܂B<br>
	 */
	public TextReader(File file, Reader<T> parser) throws ContentsFileNotFoundException {
		super(file);
		if (!file.exists()) {
			throw new ContentsFileNotFoundException("file not found : file=[" + getName() + "]");
		}
		this.reader = parser;
	}

	/**
	 * eLXgt@C̃f[^[h܂.
	 *
	 * @return thisCX^XԂ܂B<br>
	 *
	 * @throws IllegalFormatException p[T͂łȂꍇɓ܂B<br>
	 * @throws ContentsIOException t@C[hłȂꍇɓ܂B<br>
	 */
	@Override
	public TextReader<T> load() throws IllegalFormatException, ContentsIOException {
		FileReader fr = null;
		BufferedReader br = null;
		try {
			fr = new FileReader(file);
			br = new BufferedReader(fr);
			for (String line; (line = br.readLine()) != null;) {
				T val = reader.parse(line);
				if (val != null) {
					add(val);
				}
			}
			GameLog.printInfoIfUsing("TextReaderi[hj[" + file.getName() + "] size=[" + size() + "]");
		} catch (java.io.IOException ex) {
			throw new ContentsIOException(ex);
		} finally {
			try {
				if (br != null) {
					br.close();
				}
				if (fr != null) {
					fr.close();
				}
			} catch (java.io.IOException ex) {
				throw new ContentsIOException(ex);
			}
		}
		return this;
	}

	/**
	 * SẴf[^j܂.
	 *
	 * @return thisCX^XԂ܂B <br>
	 */
	@Override
	public TextReader<T> free() {
		return clear();
	}

	@Override
	public boolean isLoaded() {
		return !data.isEmpty();
	}

	@Override
	public TextReader<T> add(Collection<? extends T> obj) {
		return (TextReader<T>) super.add(obj);
	}

	@Override
	public TextReader<T> add(T obj) {
		return (TextReader<T>) super.add(obj);
	}

	@Override
	public TextReader<T> add(T... obj) {
		return (TextReader<T>) super.add(obj);
	}

	@Override
	public TextReader<T> add(TextIO<? extends T> other) {
		return (TextReader<T>) super.add(other);
	}

	@Override
	public TextReader<T> remove(Collection<? extends T> obj) {
		return (TextReader<T>) super.remove(obj);
	}

	@Override
	public TextReader<T> remove(T obj) {
		return (TextReader<T>) super.remove(obj);
	}

	@Override
	public TextReader<T> remove(T... obj) {
		return (TextReader<T>) super.remove(obj);
	}

	@Override
	public TextReader<T> remove(TextIO<? extends T> other) {
		return (TextReader<T>) super.remove(other);
	}

	@Override
	public TextReader<T> clear() {
		return (TextReader<T>) super.clear();
	}

	/**
	 * [_擾܂.
	 *
	 * @return ̃eLXgt@C͂邽߂̃[_Ԃ܂B<br>
	 */
	public Reader<T> getReader() {
		return reader;
	}

	/**
	 * [_ݒ肵܂.
	 *
	 * @param reader ̃eLXgt@C͂邽߂̃[_ݒ肵܂B<br>
	 */
	public void setReader(Reader<T> reader) {
		this.reader = reader;
	}
}
