/*
 * The MIT License
 *
 * Copyright 2015 Dra.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.game;

import kinugasa.contents.resource.Storage;

/**
 * R}hCi[܂.
 * <br>
 * R}hC`͈ȉ̂ƂB<br>
 * <br>
 * ?L[=ľ`EEEL[nameAlValueƂēo^܂B<br>
 * ?L[݂̂̌`EEEL[nameAlnullƂēo^܂B<br>
 * <br>
 * w肳ꂽɂ́ACMDArgscontains\bhgp܂B<br>
 * <br>
 *
 * @version 1.0.0 - 2015/01/03<br>
 * @author Dra<br>
 * <br>
 */
public final class CMDArgs extends Storage<CMDElement> {

	private static final CMDArgs INSTANCE = new CMDArgs();

	private CMDArgs() {
	}

	public static CMDArgs getInstance() {
		return INSTANCE;
	}

	protected void setArgs(String[] args) {
		for (String val : args) {
			String[] value = val.split("=");
			add(value.length == 2
					? new CMDElement(value)
					: new CMDElement(value[0]));
		}
	}

}
