
/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.game;

import java.awt.Graphics2D;
import kinugasa.contents.resource.Nameable;

/**
 * SẴQ[̊NXł.
 * <br>
 * ̃NX͎ɃWbN̑󂯎鋤ʃC^[tF[XƂċ@\܂B<br>
 * <br>
 *
 * @version 1.0.0 - 2013/01/13_23:22:31<br>
 * @author Dra0211<br>
 */
public abstract class Game implements Nameable {

	/** ̃Q[̖Oł. */
	protected final String name;

	/**
	 * VQ[쐬܂.
	 * @param name Q[̖Ow肵܂B<br>
	 */
	protected Game(String name) {
		this.name = name;
	}

	@Override
	public String getName() {
		return name;
	}

	/**
	 * Q[̏`܂.
	 * ̃\bh́AQ[̋NigameStartR[jɕK1xs܂B<br>
	 * Rec̃[htB[h̏`ĂB<br>
	 */
	protected abstract void startUp();

	/**
	 * Q[̏IO`܂.
	 * ̃\bh́AEChEAQ[̃CxgɂgameExit()Ă΂ꂽꍇ
	 * 1xs܂BRec̉ro߂̕ۑ`ĂB<br>
	 */
	protected abstract void dispose();

	/**
	 * Q[̍XV`܂.
	 * ̃\bh́AQ[sdraw(Graphics2D)R[OɖĂ΂܂B<br>
	 * [h̍XVW̕ύX`ĂB<br>
	 */
	protected abstract void update();

	/**
	 * Q[̍ĕ`s\bhł.
	 * ̃\bh́Arepaint()\bhĂ΂܂B̃\bh́AɂĂ
	 * 1t[ɉxR[邱Ƃ܂B<br>
	 *
	 * @param g ރOtBbNXReLXg.<br>
	 */
	protected abstract void draw(Graphics2D g);

	/**
	 * Q[[vAĕ`揈v邽߂Ɏgp郁\bhł.
	 * ̃\bhĂяoƂŁAOtBbNXReLXg쐬Adraw(Graphics2D)Ăяo悤
	 * ĂB<br>
	 */
	abstract void repaint();

	/**
	 * ̃\bhĂяoƂŁAQ[N܂.
	 * ̃\bh́AQ[̋N1xR[悤ɂĂB<br>
	 * ʏ́AC\bhŕKvȃVXevpeBݒ肵AQ[NX
	 * 쐬ɑẴ\bhĂяo܂B<br>
	 * GUItB[h̏A[vNĂB[vstartUp()Ăяo߁A<br>
	 * startUp()𖾎IɌĂяoKv͂܂B<br>
	 *
	 * @param args R}hCw肵܂B<br>
	 *	̒lCMDArgsNXɓo^܂B<br>
	 * @throws IllegalStateException Q[łɋNĂꍇɓ܂B<br>
	 */
	protected abstract void gameStart(String[] args) throws IllegalStateException;

	/**
	 * ̃\bhĂяoƂŁAQ[I܂.
	 * EChẼN[YCxgQ[̃CxgƂ
	 * ̃\bhR[邱Ƃł܂B<br>
	 * ̃\bhdispose()NƁAAvP[VI܂B<br>
	 *
	 * @throws IllegalStateException Q[łɋNĂꍇɓ܂B<br>
	 */
	public abstract void gameExit() throws IllegalStateException;

	/**
	 * Q[GUIݒ擾܂.
	 * ̃\bhɂĕԂWindowCX^XɑsƂŁA
	 * EChȄԂύX邱Ƃł܂B<br>
	 *
	 * @return ̃Q[ŎgpĂWindow̎Ԃ܂.<Br>
	 */
	public abstract GameWindow getWindow();

	/**
	 * Q[̎ԊǗNX擾܂.
	 * ̃\bhɂĕԂGameTimeManagerɑsƂ
	 * FPS̕ύXoߎԂ̎擾ł܂B<br>
	 *
	 * @return ̃Q[ŎgpĂGameTimeManagerԂ܂.<br>
	 */
	public abstract GameTimeManager getGameTimeManager();

	@Override
	public String toString() {
		return "Game{" + "name=" + name + '}';
	}
}
