/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.game;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import kinugasa.contents.graphics.ImageUtil;
import kinugasa.contents.resource.ContentsFileNotFoundException;
import kinugasa.contents.resource.ContentsIOException;
import kinugasa.contents.graphics.RenderingPolicy;

/**
 * Q[̏ݒw肷邽߂̃r_ł.
 * <br>
 * ̃NX̓Q[̋NɗlXȐݒs߂Ɏgp܂B<br>
 * Q[N̐ݒ肪ɕGȏꍇɂ́ÃNXp邱Ƃ K؂ȒlԂpNX쐬ł܂B<br>
 * <br>
 * <br>
 * ݒ\ȃIvV͈ȉ̒ʂłB<br>
 * <table border="1">
 * <tr>
 * <th>IvV</th>
 * <th></th>
 * <th>ftHgl</th>
 * <th>null̋</th>
 * <th>Q[Jn̐ݒύX</th>
 * </tr>
 *
 * <tr>
 * <td>title</td>
 * <td>Q[EChẼ^CgуQ[̖O<br>i"Q[̖O"̗pr͓ɂ܂񂪁AGameNX擾ł܂j</td>
 * <td>"My Game"</td>
 * <td>yes</td>
 * <td>kinugasa.game.GameWindow</td>
 * </tr>
 *
 * <tr>
 * <td>logPath</td>
 * <td>Ot@C̃pXiK[̃O[oOj<br>֘A@\kinugasa.util.StdOutTracerQƂ̂ƁB</td>
 * <td>null</td>
 * <td>yes<br>inull̏ꍇFOgpȂj</td>
 * <td>ύXs\</td>
 * </tr>
 *
 * <tr>
 * <td>location</td>
 * <td>Q[EChEoʒu<br>XN[ォ̃sNZPʂ̋łB<br>
 * setCenterOfScreen\bhɂAʒɐݒł܂B<br>
 * EChETCYݒ肵ĂR[ĂB</td>
 * <td>x=0, y=0</td>
 * <td></td>
 * <td>kinugasa.game.GameWindow</td>
 * </tr>
 *
 * <tr>
 * <td>size</td>
 * <td>Q[EChẼTCY</td>
 * <td>width=600, height=400</td>
 * <td></td>
 * <td>kinugasa.game.GameWindow</td>
 * </tr>
 *
 * <tr>
 * <td>backColor</td>
 * <td>Q[EChE̕`\̈̔wiF</td>
 * <td>R=48, G=68, B=142(#30448E)</td>
 * <td></td>
 * <td>kinugasa.game.GameWindow</td>
 * </tr>
 *
 * <tr>
 * <td>icon</td>
 * <td>Q[EChẼACR</td>
 * <td>KGF̃ACR</td>
 * <td>yes<br>inull̏ꍇFjavaftHgACRj</td>
 * <td>kinugasa.game.GameWindow</td>
 * </tr>
 *
 * <tr>
 * <td>fps</td>
 * <td>FPS</td>
 * <td>60</td>
 * <td></td>
 * <td>kinugasa.game.GameTimeManager</td>
 * </tr>
 *
 * <tr>
 * <td>renderingHints</td>
 * <td>_O̕i<br>ڍׂRenderingPolicymFĂBeLXg̃A`GCAXݒȂǂł܂B</td>
 * <td>kinugasa.contents.graphics.RenderingPolicy.SPEED</td>
 * <td></td>
 * <td>ύXs\</td>
 * </tr>
 *
 * <tr>
 * <td>useMouseCursor</td>
 * <td>Q[EChEŃ}EXJ[\\<br>ӁF̃IvVtrueɂȂA}EX͒l̎擾ł܂</td>
 * <td>false</td>
 * <td></td>
 * <td>ύXs\</td>
 * </tr>
 *
 * <tr>
 * <td>useKeyboard</td>
 * <td>L[XiQ[EChEɓo^AL[Ԃ\ɂ</td>
 * <td>true</td>
 * <td></td>
 * <td>ύXs\</td>
 * </tr>
 *
 * <tr>
 * <td>closeEvetList</td>
 * <td>Q[EChEۂ̃Cxg<br>ڍׂkinugasa.game.WindowCloseEventmFĂB</td>
 * <td>̃Xg</td>
 * <td></td>
 * <td>kinugasa.game.GameWindow</td>
 * </tr>
 *
 * <tr>
 * <td>lock</td>
 * <td>Q[̑dNȂ</td>
 * <td>true</td>
 * <td></td>
 * <td>ύXs</td>
 * </tr>
 *
 * <tr>
 * <td>updateIfNotActive</td>
 * <td>Q[̃CEChEANeBułȂꍇAupdaterepaintsȂ悤ɂ</td>
 * <td>true</td>
 * <td></td>
 * <td>ύXs</td>
 * </tr>
 *
 * </table>
 * <br>
 * Q[NɕύXłȂڂQ[̃IvVŕύXꍇɂ́AQ[̍ċNĔfĂB<br>
 *
 *
 * @version 1.0.0 - 2013/01/13_20:55:27<br>
 * @version 1.1.0 - 2015/01/03_07:19<br>
 * @author Dra0211<br>
 */
public class GameConfig {

	/**
	 * Q[EChẼ^Cgo[̕ł.
	 */
	private String title;
	/**
	 * Ot@C̃pXł. K[̃O[oOƂĐݒ肳܂B
	 */
	private String logPath = null;
	/**
	 * Q[EChE\ʒuł.
	 */
	private Point location = new Point(0, 0);
	/**
	 * Q[EChẼTCYł.
	 */
	private Dimension size = new Dimension(680, 480);
	/**
	 * Q[EChE̔wiFł.
	 */
	private Color backColor = new Color(48, 68, 142);
	/**
	 * Q[EChẼACRł.
	 */
	private Image icon;
	/**
	 * FPSł.
	 */
	private int fps = 60;
	/**
	 * _O̕ił.
	 */
	private RenderingHints renderingHints = RenderingPolicy.SPEED.getRenderingHints();
	/**
	 * }EXJ[\Q[EChEɕ\邩肵܂.
	 */
	private boolean useMouseCursor = false;
	/**
	 * L[͂邩肵܂.
	 */
	private boolean useKeyboard = true;
	/**
	 * EChEۂ̃Cxgł.
	 */
	private List<WindowCloseEvent> closeEvetList = new ArrayList<WindowCloseEvent>(3);

	/**
	 * Q[̑dNh~邽߂̃tOł.
	 */
	private boolean lock = true;
	private boolean updateIfNotActive = true;

	/**
	 * Kȃ^CgŃQ[ݒ쐬܂.
	 */
	public GameConfig() {
		this("My Game");
	}

	/**
	 * Q[ݒ쐬܂.
	 *
	 * @param title ^Cgo[ɕ\镶w肵܂B<br>
	 */
	public GameConfig(String title) {
		this.title = title;
		icon = new ImageIcon(getClass().getResource("icon.png")).getImage();
	}

	/**
	 * Q[EChẼ^Cgo[̕ݒ肵܂.
	 *
	 * @param title ^Cgo[ɕ\镶w肵܂B<br>
	 * @return thisCX^XԂ܂B<br>
	 */
	public GameConfig setTitle(String title) {
		this.title = title;
		return this;
	}

	/**
	 * EChEۂ̃Cxgǉ܂.
	 *
	 * @param event VCxgǉ܂B<br>
	 * @return thisCX^XԂ܂B<br>
	 */
	public GameConfig addCloseEvent(WindowCloseEvent event) {
		closeEvetList.add(event);
		return this;
	}

	/**
	 * Q[EChEoʒuw肵܂.
	 *
	 * @param location ʒuw肵܂B<br>
	 * @return thisCX^XԂ܂B<br>
	 */
	public GameConfig setLocation(Point location) {
		this.location = location;
		return this;
	}

	/**
	 * Q[EChEoʒuw肵܂.
	 *
	 * @param x Ẍʒuw肵܂B<br>
	 * @param y Ÿʒuw肵܂B<br>
	 * @return thisCX^XԂ܂B<br>
	 */
	public GameConfig setLocation(int x, int y) {
		this.location.x = x;
		this.location.y = y;
		return this;
	}

	/**
	 * Q[EChEoʒuw肵܂.
	 *
	 * @param x Ẍʒuw肵܂B<br>
	 * @return thisCX^XԂ܂B<br>
	 */
	public GameConfig setX(int x) {
		this.location.x = x;
		return this;
	}

	/**
	 * Q[EChEoʒuw肵܂.
	 *
	 * @param y Ÿʒuw肵܂B<br>
	 * @return thisCX^XԂ܂B<br>
	 */
	public GameConfig setY(int y) {
		this.location.y = y;
		return this;
	}

	/**
	 * ݂̃EChETCYgpāAEChEXN[̒ɏo悤 ʒu𒲐߂܂.
	 *
	 * @return thisCX^XԂ܂B<br>
	 */
	public GameConfig setCenterOfScreen() {
		Point centerOfScreen = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
		this.location.x = centerOfScreen.x - size.width / 2;
		this.location.y = centerOfScreen.y - size.height / 2;
		if (location.x < 0) {
			location.x = 0;
		}
		if (location.y < 0) {
			location.y = 0;
		}
		return this;
	}

	/**
	 * EChẼTCYύX܂. ̃\bhł́hTCYhƂ́A`\ȗ̈̃TCYłB āAEChỄTCÝAw肳ꂽTCY኱傫Ȃ܂B<br>
	 *
	 * @param size TCYw肵܂B<br>
	 * @return thisCX^XԂ܂B<br>
	 */
	public GameConfig setSize(Dimension size) {
		this.size = size;
		return this;
	}

	/**
	 * EChẼTCYύX܂. ̃\bhł́hTCYhƂ́A`\ȗ̈̃TCYłB āAEChỄTCÝAw肳ꂽTCY኱傫Ȃ܂B<br>
	 *
	 * @param width w肵܂B<br>
	 * @param height w肵܂B<br>
	 * @return thisCX^XԂ܂B<br>
	 */
	public GameConfig setSize(int width, int height) {
		this.size.width = width;
		this.size.height = height;
		return this;
	}

	/**
	 * EChẼTCYύX܂. ̃\bhł́hTCYhƂ́A`\ȗ̈̃TCYłB āAEChỄTCÝAw肳ꂽTCY኱傫Ȃ܂B<br>
	 *
	 * @param width w肵܂B<br>
	 * @return thisCX^XԂ܂B<br>
	 */
	public GameConfig setWidth(int width) {
		this.size.width = width;
		return this;
	}

	/**
	 * EChẼTCYύX܂. ̃\bhł́hTCYhƂ́A`\ȗ̈̃TCYłB āAEChỄTCÝAw肳ꂽTCY኱傫Ȃ܂B<br>
	 *
	 * @param height w肵܂B<br>
	 * @return thisCX^XԂ܂B<br>
	 */
	public GameConfig setHeight(int height) {
		this.size.height = height;
		return this;
	}

	/**
	 * EChE̕`\̈̔wiFw肵܂.
	 *
	 * @param backColor wiFw肵܂B<br>
	 * @return thisCX^XԂ܂B<br>
	 */
	public GameConfig setBackColor(Color backColor) {
		this.backColor = backColor;
		return this;
	}

	/**
	 * Q[EChẼACRw肵܂.
	 *
	 * @param icon EChẼACRw肵܂B<br>
	 * @return thisCX^XԂ܂B<br>
	 */
	public GameConfig setIcon(Image icon) {
		this.icon = icon;
		return this;
	}

	/**
	 * Q[EChẼACRw肵܂.
	 *
	 * @param filePath EChẼACR̃t@CpXw肵܂B<br>
	 * @return thisCX^XԂ܂B<br>
	 * @throws ContentsFileNotFoundException 摜t@C݂ȂƂɓ܂B<br>
	 * @throws ContentsIOException 摜[hłȂꍇɓ܂B<br>
	 */
	public GameConfig setIcon(String filePath)
			throws ContentsFileNotFoundException, ContentsIOException {
		if (filePath == null) {
			setIcon((Image) null);
		} else {
			setIcon(ImageUtil.load(filePath));
		}
		return this;
	}

	/**
	 * FPS̍őlݒ肵܂.
	 *
	 * @param fps FPSw肵܂Bʏ30?60łB<br>
	 * @return thisCX^XԂ܂B<br>
	 */
	public GameConfig setFps(int fps) {
		this.fps = fps;
		return this;
	}

	/**
	 * `iݒ肵܂. `̕iݒ肷ƁA摜v~eBu}ꂢɕ\ł܂A `摬x܂B<br>
	 * Q[fUClAiƑx̃oXƂݒ߂Kv܂B
	 *
	 * @param renderingHints _O̐ݒ𑗐M܂B<br>
	 * @return thisCX^XԂ܂B<br>
	 */
	public GameConfig setRenderingHints(RenderingHints renderingHints) {
		this.renderingHints = renderingHints;
		return this;
	}

	/**
	 * `iݒ肵܂. `̕iݒ肷ƁA摜v~eBu}ꂢɕ\ł܂A `摬x܂B<br>
	 * Q[fUClAiƑx̃oXƂݒ߂Kv܂B
	 *
	 * @param policy _O̐ݒ𑗐M܂B<br>
	 * @return thisCX^XԂ܂B<br>
	 */
	public GameConfig setRenderingHints(RenderingPolicy policy) {
		this.renderingHints = policy.getRenderingHints();
		return this;
	}

	/**
	 * Ot@CpXݒ肵܂. ݒ肳ꂽl̓K[̃O[opXƂĎgpAt[[NŜ̃Oo͂Ɏgp܂B<br>
	 *
	 * @param logPath Ot@C̃pXBnull̏ꍇ̓Ot@Cgp܂B
	 * @return thisCX^XԂ܂B<br>
	 */
	public GameConfig setLogPath(String logPath) {
		this.logPath = logPath;
		return this;
	}

	/**
	 * Ot@CpXݒ肵܂. ݒ肳ꂽl̓K[̃O[opXƂĎgpAt[[NŜ̃Oo͂Ɏgp܂B<br>
	 *
	 * @param logPath Ot@C̃pXBnull̏ꍇ̓Ot@Cgp܂B
	 * @return thisCX^XԂ܂B<br>
	 */
	public GameConfig setLogPathAndMKDIR(String logPath) {
		File dir = new File(logPath).getParentFile();
		if (!dir.exists()) {
			dir.mkdir();
		}
		this.logPath = logPath;
		return this;
	}

	/**
	 * Q[EChEŃ}EXJ[\gp邩肵܂.
	 *
	 * @param use truew肷ƗL܂B<br>
	 * @return thisCX^XԂ܂B<br>
	 */
	public GameConfig useMouse(boolean use) {
		this.useMouseCursor = use;
		return this;
	}

	/**
	 * L[XiQ[EChEɓo^AL[Ԃ\ɂ邩肵܂.
	 *
	 * @param use truew肷ƗL܂B<br>
	 * @return thisCX^XԂ܂B<br>
	 */
	public GameConfig useKeyboard(boolean use) {
		this.useKeyboard = use;
		return this;
	}

	/**
	 * dNeF܂B<br>
	 *
	 * @return thisCX^XԂ܂B<br>
	 */
	public GameConfig noLock() {
		this.lock = false;
		return this;
	}

	public GameConfig updateIfNotActive(boolean updateIfNotActive) {
		this.updateIfNotActive = updateIfNotActive;
		return this;
	}

	public boolean isLock() {
		return lock;
	}

	/**
	 * Q[EChE̔wiF擾܂. ̃\bhKinugasaGameNXgp܂B<br>
	 *
	 * @return wiFԂ܂B<br>
	 */
	protected Color getBackColor() {
		return backColor;
	}

	/**
	 * FPS̍ől擾܂. ̃\bhKinugasaGameNXgp܂B<br>
	 *
	 * @return FPS̍őlԂ܂B<br>
	 */
	protected int getFps() {
		return fps;
	}

	/**
	 * Q[EChẼACR擾܂. ̃\bhKinugasaGameNXgp܂B<br>
	 *
	 * @return ACRԂ܂B<br>
	 */
	protected Image getIcon() {
		return icon;
	}

	/**
	 * Q[EChȄoʒu擾܂. ̃\bhKinugasaGameNXgp܂B<br>
	 *
	 * @return Q[EChȄoʒuԂ܂B<br>
	 */
	protected Point getLocation() {
		return location;
	}

	/**
	 * `i擾܂. ̃\bhKinugasaGameNXgp܂B<br>
	 *
	 * @return `i̐ݒԂ܂B<br>
	 */
	protected RenderingHints getRenderingHints() {
		return renderingHints;
	}

	/**
	 * Q[EChẼTCY擾܂. ̃\bhKinugasaGameNXgp܂B<br>
	 *
	 * @return Q[EChẼTCYԂ܂B<br>
	 */
	protected Dimension getSize() {
		return size;
	}

	/**
	 * Q[EChẼ^Cg擾܂. ̃\bhKinugasaGameNXgp܂B<br>
	 *
	 * @return Q[EChẼ^CgƃQ[NX̖OƂȂ Ԃ܂B<br>
	 */
	protected String getTitle() {
		return title;
	}

	/**
	 * }EXJ[\gp邩肵܂. ̃\bhKinugasaGameNXgp܂B<br>
	 *
	 * @return }EXJ[\gpꍇtrueԂ܂B<br>
	 */
	protected boolean isUseMouseCursor() {
		return useMouseCursor;
	}

	/**
	 * L[{[hgp邩肵܂. ̃\bhKinugasaGameNXgp܂B<br>
	 *
	 * @return L[{[hgpꍇtrueԂ܂B<br>
	 */
	protected boolean isUseKeyboard() {
		return useKeyboard;
	}

	/**
	 * Ot@CpX擾܂. ̃\bhKinugasaGameNXgp܂B<br>
	 *
	 * @return Ot@C̃pXBgpȂꍇnullB
	 */
	protected String getLogPath() {
		return logPath;
	}

	/**
	 * ǉꂽEChEN[YCxg擾܂. ̃\bhKinugasaGameNXgp܂B<br>
	 *
	 * @return ̃Q[ݒɒǉĂEChEN[YCxgǉꂽ XgƂĎ擾܂B<br>
	 */
	protected List<WindowCloseEvent> getCloseEvetList() {
		return closeEvetList;
	}

	public boolean isUpdateIfNotActive() {
		return updateIfNotActive;
	}

	@Override
	public String toString() {
		return "GameConfig{" + "title=" + title + ", logPath=" + logPath
				+ ", location=" + location + ", size=" + size + ", backColor="
				+ backColor + ", icon=" + icon + ", fps=" + fps
				+ ", renderingHints=" + renderingHints + ", useMouseCursor="
				+ useMouseCursor + ", useKeyboard=" + useKeyboard
				+ ", closeEvetList=" + closeEvetList + '}';
	}

}
