/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.game;


/**
 * Q[̐isԂǗAFPSɕۂ߂̋@\񋟂܂.
 * <br>
 *
 * <br>
 *
 * @version 1.0.0 - 2013/01/14_12:33:16<br>
 * @author Dra0211<br>
 */
public final class GameTimeManager {

	/** Pʎԓ̍XV. */
	private int updateNum;
	/** O񌟍̎. */
	private long prevTime;
	/** ݂̎. */
	private long nowTime;
	/** ݂FPS. */
	private float fps;
	/** X[vł̑҂. */
	private long waitTime;
	/** Jňo߃t[. */
	private long totalFrame = 0L;
	/** X[v̏I. */
	private long endTime;

	/**
	 * FPS̍ől60̐VTimeManager쐬܂.
	 */
	GameTimeManager() {
		this(60);
	}

	/**
	 * VTimeManager쐬܂.
	 *
	 * @param idealFPS FPS̍ől.<Br>
	 */
	GameTimeManager(int idealFPS) {
		waitTime = 1000 / idealFPS * 1000000;
		updateNum = idealFPS;
		prevTime = System.nanoTime() - 1000000000;
	}

	/**
	 * FPS̍ől擾܂.
	 * ̃\bh̖߂l̓~bxɊۂ߂.
	 *
	 * @return FPS̍ől.<br>
	 */
	public long getIdealFPS() {
		return 1000000000 / waitTime;
	}

	/**
	 * FPS̍őlݒ肵܂.
	 *
	 * @param idealFPS FPS̍ől.<br>
	 */
	public void setIdealFPS(int idealFPS) {
		waitTime = 1000 / idealFPS * 1000000;
		updateNum = idealFPS;
	}

	/**
	 * ݂FPS擾܂.
	 *
	 * @return ݂FPS.<br>
	 */
	public float getFPS() {
		return fps;
	}

	/**
	 * FPŜݎ\L擾܂.
	 * ̃\bh̖߂l͒Pxł.<Br>
	 *
	 * @return FPS̕\L.ʏ͏ȉ6xɂȂ.<br>
	 */
	public String getFPSStr() {
		return Float.toString(getFPS());
	}

	/**
	 * w肵FPS̕\L擾܂.
	 *
	 * @param d _ȉ̌.<Br>
	 *
	 * @return w肵̐؂̂ĂꂽFPS\L.<Br>
	 *
	 * @throws IllegalArgumentException d̏ꍇɓ.<Br>
	 */
	public String getFPSStr(int d) throws IllegalArgumentException {
		if (d < 0) {
			throw new IllegalArgumentException("disit is minus");
		}
		String s = getFPSStr();
		int dotPosition = s.indexOf('.');
		if (dotPosition <= 0) {
			return s;
		}
		if (d == 0) {
			return s.substring(0, dotPosition);
		}
		dotPosition += d;
		if (s.length() <= dotPosition) {
			return s;
		}
		return s.substring(0, dotPosition + 1);
	}

	/**
	 * Jňo߃t[擾܂.
	 *
	 * @return Jňo߃t[.<br>
	 */
	public long getTotalFrame() {
		return totalFrame;
	}

	/**
	 * Jňo߃t[܂.
	 */
	public void resetTotalFrame() {
		totalFrame = 0L;
	}

	/**
	 * ̃\bhĂԂƁA炩ߐݒ肳ꂽFPSێł鎞ԂsXbhsleep܂.
	 *
	 * @param startTime JnO̎nanobxőM܂B<br>
	 */
	void sleep(long startTime) {
		nowTime = System.nanoTime();
		endTime = nowTime + (waitTime - (nowTime - startTime));//I(ns
		while (System.nanoTime() < endTime) {//System.nanoTimeCNĝ𗘗pĂ
			try {
				Thread.sleep(1);
			} catch (InterruptedException ex) {
				GameLog.printInfoIfUsing("! > interrupted in main Thread sleep");
				ex.printStackTrace();
			}
		}
		nowTime = System.nanoTime();//X[vĂ̂ŌݎXV
		totalFrame++;
		updateNum++;
		if (nowTime - prevTime > 1000000000) {//1s
			fps = (float) updateNum / ((nowTime - prevTime) / 1000000000f);
			updateNum = 0;
			prevTime = nowTime;
		}
	}
}
