/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.game;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyListener;

/**
 * Q[\EChEɑ΂鑀`܂.
 * <br>
 *
 * <br>
 *
 * @version 1.0.0 - 2013/04/20_17:34:07<br>
 * @author Dra0211<br>
 */
public interface GameWindow {

	/**
	 * EChEXWݒ肵܂.
	 *
	 * @param x XW.<br>
	 */
	public void setX(int x);

	/**
	 * EChEXWݒ肵܂.
	 *
	 * @param y YW.<br>
	 */
	public void setY(int y);

	/**
	 * EChEXW擾܂.
	 *
	 * @return EChEXW.<br>
	 */
	public int getX();

	/**
	 * EChEYW擾܂.
	 *
	 * @return EChEYW.<br>
	 */
	public int getY();

	/**
	 * EChE̕擾܂.
	 *
	 * @return EChE̕.<Br>
	 */
	public int getWidth();

	/**
	 * EChE̍擾܂.
	 *
	 * @return EChE̍.<Br>
	 */
	public int getHeight();

	/**
	 * EChËʒuݒ肵܂.
	 *
	 * @param x EChEXW.<br>
	 * @param y EChEYW.<br>
	 */
	public void setLocation(int x, int y);

	/**
	 * EChËʒuݒ肵܂.
	 *
	 * @param p EChE̍W.<br>
	 */
	public void setLocation(Point p);

	/**
	 * EChËʒu擾܂.
	 *
	 * @return EChËʒu.<br>
	 */
	public Point getLocation();

	/**
	 * EChË̗擾܂. ̃\bhł́AEChẼ{[_܂񂾃EChEŜ̗̈Ԃ܂B<br>
	 *
	 * @return EChËʒuуTCYԂ܂B<br>
	 */
	public Rectangle getBounds();

	/**
	 * EChE̎gp\ȓ̈擾܂. ̃\bhł́AEChẼ{[_܂܂Ȃۂɕ`\ȗ̈悪Ԃ܂B<br>
	 * ʏÄ̗̈ʒu0,0ɒԂ܂B<br>
	 *
	 * @return EChE̎gp\ȗ̈Ԃ܂B<br>
	 */
	public Rectangle getInternalBounds();

	/**
	 * EChE̘g̕Ԃ܂.
	 *
	 * @return EChẼ{[_̕Ԃ܂B<Br>
	 */
	public Insets getInsets();

	/**
	 * EChE̔wiFݒ肵܂.
	 *
	 * @param color wiFB<br>
	 */
	public void setBackground(Color color);

	/**
	 * EChE̔wiF擾܂B<br>
	 *
	 * @return EChE̔wiFB<br>
	 */
	public Color getBackground();

	/**
	 * EChEɐݒ肳ĂACR擾܂.
	 *
	 * @return EChẼACRB<br>
	 */
	public Image getIconImage();

	/**
	 * EChẼACRύX܂.
	 *
	 * @param image EChẼACRB<br>
	 */
	public void setIconImage(Image image);

	/**
	 * EChẼ^Cgo[̕擾܂.
	 *
	 * @return EChẼ^Cgo[ɕ\Ă镶Ԃ܂B<br>
	 */
	public String getTitle();

	/**
	 * EChẼ^Cgo[ݒ肵܂.
	 *
	 * @param title EChẼ^Cgo[ɕ\镶w肵܂B<br>
	 */
	public void setTitle(String title);

	/**
	 * EChEIĂA\ł邩܂. ʏAEChEANeBułȂꍇ̓Q[̐is͒~܂B<br>
	 *
	 * @return EChEANeBułꍇtrueԂ܂B<br>
	 */
	public boolean isActive();

	/**
	 * }EXJ[\ݒ肵܂.
	 *
	 * @param cursor VJ[\w肵܂B<br>
	 */
	public void setCursor(Cursor cursor);

	/**
	 * ݂̃}EXJ[\擾܂.
	 *
	 * @return gp̃}EXJ[\Ԃ܂B<br>
	 */
	public Cursor getCursor();

	/**
	 * EChEN[YCxgɊւ鑀sXg[W擾܂. ftHgł́A"GAME_EXIT"ƂOgameExits ǉĂ܂B̒ǉKinugasaGameNX̃RXgN^ s܂B<br>
	 *
	 * @return EChEɐݒ肳ꂽN[YCxgXg[WԂ܂B<br>
	 */
	public CloseEventStorage getCloseEventStorage();

	public KeyListener[] getKeyListeners();
}
