/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.game;

import java.io.Serializable;
import kinugasa.contents.resource.Nameable;

/**
 * EChEۂ̔@\`܂.
 * <br>
 * N[YCxg̓EChEۂɎsCxgłB<br>
 * ̃Cxg͖OїDx܂BO͏dĂ͂Ȃ܂B<br>
 * Dx́ACxgsƂɎQƂA\[g܂BDx̒lCxg
 * Ɏs܂B<br>
 * CxghQ[IȂhƂꍇAȍ~̃Cxg͎s܂B<br>
 * <br>
 * @version 1.0.0 - 2013/04/20_17:36:30<br>
 * @author Dra0211<br>
 */
public abstract class WindowCloseEvent implements Nameable, Comparable<WindowCloseEvent>, Serializable {

	private static final long serialVersionUID = 1518579368912928490L;
	/** ̃Cxg̖Oł. */
	private String name;
	/** ̃Cxg̗Dxł. */
	private int priority;

	/**
	 * Dx0̃N[YCxg쐬܂.
	 * @param name Cxg̈ӓIȖOw肵܂B<br>
	 */
	public WindowCloseEvent(String name) {
		this(name, 0);
	}

	/**
	 * VN[YCxg쐬܂.
	 * @param name Cxg̈ӓIȖOw肵܂B<br>
	 * @param priority ̃Cxg̗Dxw肵܂B<br>
	 */
	public WindowCloseEvent(String name, int priority) {
		this.name = name;
		this.priority = priority;
	}

	@Override
	public String getName() {
		return name;
	}

	/**
	 * ̃Cxg̗Dx擾܂.
	 * @return Cxg̗DxԂ܂B<br>
	 */
	public int getPriority() {
		return priority;
	}

	/**
	 * ̃Cxg̗Dxݒ肵܂.
	 * @param priority Cxg̗Dx𑗐M܂B<br>
	 */
	public void setPriority(int priority) {
		this.priority = priority;
	}

	/**
	 * EChEۂ̔s܂.
	 * @return EChEꍇtrueAȂꍇfalseԂ܂B
	 * ǉĂSẴEChEN[YCxgtrueԂƁA
	 * EChEAQ[I܂B<br>
	 */
	public abstract boolean close();

	@Override
	public int compareTo(WindowCloseEvent t) {
		return t.priority - this.priority;
	}

	@Override
	public int hashCode() {
		int hash = 3;
		hash = 67 * hash + (this.name != null ? this.name.hashCode() : 0);
		return hash;
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		final WindowCloseEvent other = (WindowCloseEvent) obj;
		if ((this.name == null) ? (other.name != null) : !this.name.equals(other.name)) {
			return false;
		}
		return true;
	}

	@Override
	public String toString() {
		return "WindowCloseEvent{" + "name=" + name + ", priority=" + priority + '}';
	}
}